/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.cas.credentials.extractor;

import java.util.zip.Inflater;
import javax.xml.bind.DatatypeConverter;
import org.jasig.cas.client.util.CommonUtils;
import org.pac4j.cas.config.CasConfiguration;
import org.pac4j.cas.logout.CasLogoutHandler;
import org.pac4j.core.context.ContextHelper;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.credentials.TokenCredentials;
import org.pac4j.core.credentials.extractor.CredentialsExtractor;
import org.pac4j.core.exception.HttpAction;
import org.pac4j.core.exception.TechnicalException;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.core.util.InitializableWebObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TicketAndLogoutRequestExtractor
extends InitializableWebObject
implements CredentialsExtractor<TokenCredentials> {
    private static final int DECOMPRESSION_FACTOR = 10;
    private static final Logger logger = LoggerFactory.getLogger(TicketAndLogoutRequestExtractor.class);
    private CasConfiguration configuration;
    private String clientName;

    public TicketAndLogoutRequestExtractor() {
    }

    public TicketAndLogoutRequestExtractor(CasConfiguration configuration, String clientName) {
        this.configuration = configuration;
        this.clientName = clientName;
    }

    protected void internalInit(WebContext context) {
        CommonHelper.assertNotNull((String)"configuration", (Object)((Object)this.configuration));
        CommonHelper.assertNotBlank((String)"clientName", (String)this.clientName);
        this.configuration.init(context);
    }

    public TokenCredentials extract(WebContext context) throws HttpAction {
        this.init(context);
        CasLogoutHandler logoutHandler = this.configuration.getLogoutHandler();
        if (this.isTokenRequest(context)) {
            String ticket = context.getRequestParameter("ticket");
            if (logoutHandler != null) {
                logoutHandler.recordSession(context, ticket);
            }
            TokenCredentials casCredentials = new TokenCredentials(ticket, this.clientName);
            logger.debug("casCredentials: {}", (Object)casCredentials);
            return casCredentials;
        }
        if (this.isBackLogoutRequest(context)) {
            String logoutMessage = context.getRequestParameter("logoutRequest");
            logger.trace("Logout request:\n{}", (Object)logoutMessage);
            String ticket = CommonHelper.substringBetween((String)logoutMessage, (String)"SessionIndex>", (String)"</");
            if (CommonUtils.isNotBlank((String)ticket) && logoutHandler != null) {
                logoutHandler.destroySessionBack(context, ticket);
            }
            String message = "back logout request: no credential returned";
            logger.debug("back logout request: no credential returned");
            throw HttpAction.ok((String)"back logout request: no credential returned", (WebContext)context, (String)"");
        }
        if (this.isFrontLogoutRequest(context)) {
            String logoutMessage = this.uncompressLogoutMessage(context.getRequestParameter("logoutRequest"));
            logger.trace("Logout request:\n{}", (Object)logoutMessage);
            String ticket = CommonHelper.substringBetween((String)logoutMessage, (String)"SessionIndex>", (String)"</");
            if (CommonUtils.isNotBlank((String)ticket) && logoutHandler != null) {
                logoutHandler.destroySessionFront(context, ticket);
            }
            logger.debug("front logout request: no credential returned");
            this.computeRedirectionToServerIfNecessary(context);
        }
        return null;
    }

    protected boolean isTokenRequest(WebContext context) {
        return ContextHelper.isGet((WebContext)context) && CommonHelper.isNotBlank((String)context.getRequestParameter("ticket"));
    }

    protected boolean isBackLogoutRequest(WebContext context) {
        return ContextHelper.isPost((WebContext)context) && !this.isMultipartRequest(context) && CommonHelper.isNotBlank((String)context.getRequestParameter("logoutRequest"));
    }

    private boolean isMultipartRequest(WebContext context) {
        String contentType = context.getRequestHeader("Content-Type");
        return contentType != null && contentType.toLowerCase().startsWith("multipart");
    }

    private boolean isFrontLogoutRequest(WebContext context) {
        return ContextHelper.isGet((WebContext)context) && CommonHelper.isNotBlank((String)context.getRequestParameter("logoutRequest"));
    }

    private String uncompressLogoutMessage(String originalMessage) {
        byte[] binaryMessage = DatatypeConverter.parseBase64Binary((String)originalMessage);
        Inflater decompresser = null;
        try {
            decompresser = new Inflater();
            decompresser.setInput(binaryMessage);
            byte[] result = new byte[binaryMessage.length * 10];
            int resultLength = decompresser.inflate(result);
            String string = new String(result, 0, resultLength, "UTF-8");
            return string;
        }
        catch (Exception e) {
            logger.error("Unable to decompress logout message", (Throwable)e);
            throw new TechnicalException((Throwable)e);
        }
        finally {
            if (decompresser != null) {
                decompresser.end();
            }
        }
    }

    private void computeRedirectionToServerIfNecessary(WebContext context) throws HttpAction {
        String relayStateValue = context.getRequestParameter("RelayState");
        if (CommonUtils.isNotBlank((String)relayStateValue)) {
            StringBuilder buffer = new StringBuilder();
            buffer.append(this.configuration.getPrefixUrl());
            if (!this.configuration.getPrefixUrl().endsWith("/")) {
                buffer.append("/");
            }
            buffer.append("logout?_eventId=next&");
            buffer.append("RelayState");
            buffer.append("=");
            buffer.append(CommonUtils.urlEncode((String)relayStateValue));
            String redirectUrl = buffer.toString();
            logger.debug("Redirection url to the CAS server: {}", (Object)redirectUrl);
            throw HttpAction.redirect((String)"Force redirect to CAS server for front channel logout", (WebContext)context, (String)redirectUrl);
        }
    }

    public CasConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(CasConfiguration configuration) {
        this.configuration = configuration;
    }

    public String getClientName() {
        return this.clientName;
    }

    public void setClientName(String clientName) {
        this.clientName = clientName;
    }
}

