/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.common.experimental.impl;

import java.util.function.Function;
import org.optaplanner.examples.common.experimental.impl.IntervalSplitPoint;

public class Interval<IntervalValue_, PointValue_ extends Comparable<PointValue_>> {
    final IntervalValue_ value;
    final IntervalSplitPoint<IntervalValue_, PointValue_> startSplitPoint;
    final IntervalSplitPoint<IntervalValue_, PointValue_> endSplitPoint;

    public Interval(IntervalValue_ value, Function<IntervalValue_, PointValue_> startMapping, Function<IntervalValue_, PointValue_> endMapping) {
        this.value = value;
        this.startSplitPoint = new IntervalSplitPoint((Comparable)startMapping.apply(value));
        this.endSplitPoint = new IntervalSplitPoint((Comparable)endMapping.apply(value));
    }

    public IntervalValue_ getValue() {
        return this.value;
    }

    public PointValue_ getStart() {
        return this.startSplitPoint.splitPoint;
    }

    public PointValue_ getEnd() {
        return this.endSplitPoint.splitPoint;
    }

    public IntervalSplitPoint<IntervalValue_, PointValue_> getStartSplitPoint() {
        return this.startSplitPoint;
    }

    public IntervalSplitPoint<IntervalValue_, PointValue_> getEndSplitPoint() {
        return this.endSplitPoint;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Interval that = (Interval)o;
        return this.value == that.value;
    }

    public int hashCode() {
        return System.identityHashCode(this.value);
    }

    public String toString() {
        return "Interval{value=" + this.value + ", start=" + this.getStart() + ", end=" + this.getEnd() + '}';
    }
}

