/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.batchscheduling.swingui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import org.optaplanner.examples.batchscheduling.domain.Allocation;
import org.optaplanner.examples.batchscheduling.domain.AllocationPath;
import org.optaplanner.examples.batchscheduling.domain.Batch;
import org.optaplanner.examples.batchscheduling.domain.BatchSchedule;
import org.optaplanner.examples.batchscheduling.domain.RoutePath;
import org.optaplanner.examples.batchscheduling.domain.Segment;
import org.optaplanner.examples.common.swingui.SolutionPanel;

public class BatchSchedulingPanel
extends SolutionPanel<BatchSchedule> {
    private static final long serialVersionUID = 1L;
    public static final String LOGO_PATH = "/org/optaplanner/examples/batchscheduling/swingui/batchSchedulingLogo.png";

    public BatchSchedulingPanel() {
        this.setLayout(new BorderLayout());
    }

    @Override
    public void resetPanel(BatchSchedule solution) {
        this.removeAll();
        this.repaint();
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.add("Batches", this.createComponentPanel1(solution));
        tabbedPane.add("RoutePaths", this.createComponentPanel2(solution));
        tabbedPane.add("Segments", this.createComponentPanel3(solution));
        tabbedPane.add("Allocations", this.createComponentPanel4(solution));
        this.add((Component)tabbedPane, "Center");
        this.setPreferredSize(PREFERRED_SCROLLABLE_VIEWPORT_SIZE);
        this.add(tabbedPane);
    }

    private JScrollPane createComponentPanel1(BatchSchedule solution) {
        SimpleDateFormat formatter = new SimpleDateFormat("HH:mm:ss");
        Date date = new Date();
        String strDate = formatter.format(date);
        ArrayList<String> tableHeader = new ArrayList<String>();
        ArrayList<List<String>> tableData = new ArrayList<List<String>>();
        tableHeader.add("Batch");
        tableHeader.add("Volume");
        tableHeader.add("DelayRangeValue");
        tableHeader.add("Time Refreshed");
        for (Batch batch : solution.getBatchList()) {
            ArrayList<String> rowData = new ArrayList<String>();
            rowData.add(batch.getName());
            rowData.add(batch.getVolume().toString());
            rowData.add(batch.getDelayRangeValue().toString());
            rowData.add(strDate);
            tableData.add(rowData);
        }
        JTable table = new JTable(BatchSchedulingPanel.tableToArray(tableData), BatchSchedulingPanel.tableRowToArray(tableHeader));
        table.getColumnModel().getColumn(1).setMinWidth(300);
        JScrollPane componentPanel = new JScrollPane(table);
        table.setFillsViewportHeight(true);
        return componentPanel;
    }

    private JScrollPane createComponentPanel2(BatchSchedule solution) {
        SimpleDateFormat formatter = new SimpleDateFormat("HH:mm:ss");
        Date date = new Date();
        String strDate = formatter.format(date);
        ArrayList<String> tableHeader = new ArrayList<String>();
        ArrayList<List<String>> tableData = new ArrayList<List<String>>();
        tableHeader.add("Batch");
        tableHeader.add("RoutePath");
        tableHeader.add("Selected");
        tableHeader.add("Time Refreshed");
        for (Batch batch : solution.getBatchList()) {
            for (RoutePath routePath : batch.getRoutePathList()) {
                ArrayList<String> rowData = new ArrayList<String>();
                String strSelectedRoutePath = "";
                rowData.add(batch.getName());
                rowData.add(routePath.getPath());
                if (solution.getAllocationPathList() != null) {
                    for (AllocationPath allocationPath : solution.getAllocationPathList()) {
                        if (allocationPath.getBatch() == null || allocationPath.getRoutePath() == null || !allocationPath.getBatch().getName().equals(batch.getName()) || !allocationPath.getRoutePath().getPath().equals(routePath.getPath())) continue;
                        strSelectedRoutePath = "Selected";
                    }
                }
                rowData.add(strSelectedRoutePath);
                rowData.add(strDate);
                tableData.add(rowData);
            }
        }
        JTable table = new JTable(BatchSchedulingPanel.tableToArray(tableData), BatchSchedulingPanel.tableRowToArray(tableHeader));
        table.getColumnModel().getColumn(1).setMinWidth(300);
        JScrollPane componentPanel = new JScrollPane(table);
        table.setFillsViewportHeight(true);
        return componentPanel;
    }

    private JScrollPane createComponentPanel3(BatchSchedule solution) {
        ArrayList<String> tableHeader = new ArrayList<String>();
        ArrayList<List<String>> tableData = new ArrayList<List<String>>();
        tableHeader.add("Batch");
        tableHeader.add("RoutePath");
        tableHeader.add("Segment");
        tableHeader.add("Length");
        tableHeader.add("FlowRate");
        tableHeader.add("Delay");
        tableHeader.add("Start Injection Time");
        tableHeader.add("End Injection Time");
        tableHeader.add("Start Delivery Time");
        tableHeader.add("End Delivery Time");
        tableHeader.add("Predecessor Start Delivery Time");
        for (Batch batch : solution.getBatchList()) {
            for (RoutePath routePath : batch.getRoutePathList()) {
                for (Segment segment : routePath.getSegmentList()) {
                    ArrayList<String> rowData = new ArrayList<String>();
                    String strLength = "";
                    String strFlowRate = "";
                    String strDelay = "";
                    String strStartTime1 = "";
                    String strEndTime1 = "";
                    String strStartTime2 = "";
                    String strEndTime2 = "";
                    String strPEndTime = "";
                    rowData.add(batch.getName());
                    rowData.add(routePath.getPath());
                    rowData.add(segment.getName());
                    if (solution.getAllocationList() != null) {
                        for (Allocation allocation : solution.getAllocationList()) {
                            if (allocation.getBatch() == null || allocation.getRoutePath() == null || allocation.getSegment() == null || !allocation.getBatch().getName().equals(batch.getName()) || !allocation.getRoutePath().getPath().equals(routePath.getPath()) || !allocation.getSegment().getName().equals(segment.getName())) continue;
                            if (allocation.getSegment() != null) {
                                strLength = Float.toString(allocation.getSegment().getLength());
                                strFlowRate = Float.toString(allocation.getSegment().getFlowRate());
                            } else {
                                strLength = "";
                                strFlowRate = "";
                            }
                            strDelay = allocation.getDelay() != null ? allocation.getDelay().toString() : "";
                            strStartTime1 = allocation.getStartInjectionTime() != null ? allocation.getStartInjectionTime().toString() : "";
                            strEndTime1 = allocation.getEndInjectionTime() != null ? allocation.getEndInjectionTime().toString() : "";
                            strStartTime2 = allocation.getStartDeliveryTime() != null ? allocation.getStartDeliveryTime().toString() : "";
                            strEndTime2 = allocation.getEndDeliveryTime() != null ? allocation.getEndDeliveryTime().toString() : "";
                            if (allocation.getPredecessorsDoneDate() != null) {
                                strPEndTime = allocation.getPredecessorsDoneDate().toString();
                                continue;
                            }
                            strPEndTime = "";
                        }
                    }
                    rowData.add(strLength);
                    rowData.add(strFlowRate);
                    rowData.add(strDelay);
                    rowData.add(strStartTime1);
                    rowData.add(strEndTime1);
                    rowData.add(strStartTime2);
                    rowData.add(strEndTime2);
                    rowData.add(strPEndTime);
                    tableData.add(rowData);
                }
            }
        }
        JTable table = new JTable(BatchSchedulingPanel.tableToArray(tableData), BatchSchedulingPanel.tableRowToArray(tableHeader));
        table.getColumnModel().getColumn(1).setMinWidth(300);
        JScrollPane componentPanel = new JScrollPane(table);
        table.setFillsViewportHeight(true);
        return componentPanel;
    }

    private JScrollPane createComponentPanel4(BatchSchedule solution) {
        ArrayList<String> tableHeader = new ArrayList<String>();
        ArrayList<List<String>> tableData = new ArrayList<List<String>>();
        tableHeader.add("Batch");
        tableHeader.add("RoutePath");
        tableHeader.add("Segment");
        tableHeader.add("Length");
        tableHeader.add("FlowRate");
        tableHeader.add("Delay");
        tableHeader.add("Start Injection Time");
        tableHeader.add("End Injection Time");
        tableHeader.add("Start Delivery Time");
        tableHeader.add("End Delivery Time");
        tableHeader.add("Predecessor Start Delivery Time");
        for (Batch batch : solution.getBatchList()) {
            for (RoutePath routePath : batch.getRoutePathList()) {
                for (Segment segment : routePath.getSegmentList()) {
                    ArrayList<String> rowData = new ArrayList<String>();
                    String strLength = "";
                    String strFlowRate = "";
                    String strDelay = "";
                    String strStartTime1 = "";
                    String strEndTime1 = "";
                    String strStartTime2 = "";
                    String strEndTime2 = "";
                    String strPEndTime = "";
                    rowData.add(batch.getName());
                    rowData.add(routePath.getPath());
                    rowData.add(segment.getName());
                    if (solution.getAllocationList() != null) {
                        for (Allocation allocation : solution.getAllocationList()) {
                            if (allocation.getBatch() == null || allocation.getRoutePath() == null || allocation.getSegment() == null || !allocation.getBatch().getName().equals(batch.getName()) || !allocation.getRoutePath().getPath().equals(routePath.getPath()) || !allocation.getSegment().getName().equals(segment.getName())) continue;
                            if (allocation.getSegment() != null) {
                                strLength = Float.toString(allocation.getSegment().getLength());
                                strFlowRate = Float.toString(allocation.getSegment().getFlowRate());
                            } else {
                                strLength = "";
                                strFlowRate = "";
                            }
                            strDelay = allocation.getDelay() != null ? allocation.getDelay().toString() : "";
                            strStartTime1 = allocation.getStartInjectionTime() != null ? allocation.getStartInjectionTime().toString() : "";
                            strEndTime1 = allocation.getEndInjectionTime() != null ? allocation.getEndInjectionTime().toString() : "";
                            strStartTime2 = allocation.getStartDeliveryTime() != null ? allocation.getStartInjectionTime().toString() : "";
                            strEndTime2 = allocation.getEndDeliveryTime() != null ? allocation.getEndDeliveryTime().toString() : "";
                            if (allocation.getPredecessorsDoneDate() != null) {
                                strPEndTime = allocation.getPredecessorsDoneDate().toString();
                                continue;
                            }
                            strPEndTime = "";
                        }
                    }
                    if (strDelay.equals("") && strStartTime1.equals("") && strEndTime1.equals("") && strPEndTime.equals("")) continue;
                    rowData.add(strLength);
                    rowData.add(strFlowRate);
                    rowData.add(strDelay);
                    rowData.add(strStartTime1);
                    rowData.add(strEndTime1);
                    rowData.add(strStartTime2);
                    rowData.add(strEndTime2);
                    rowData.add(strPEndTime);
                    tableData.add(rowData);
                }
            }
        }
        JTable table = new JTable(BatchSchedulingPanel.tableToArray(tableData), BatchSchedulingPanel.tableRowToArray(tableHeader));
        table.getColumnModel().getColumn(1).setMinWidth(300);
        JScrollPane componentPanel = new JScrollPane(table);
        table.setFillsViewportHeight(true);
        return componentPanel;
    }

    private static Object[] tableRowToArray(List<String> tableRow) {
        return tableRow.toArray();
    }

    private static Object[][] tableToArray(List<List<String>> tableData) {
        return (Object[][])tableData.stream().map(BatchSchedulingPanel::tableRowToArray).toArray(x$0 -> new Object[x$0][]);
    }
}

