/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.batchscheduling.app;

import org.optaplanner.examples.batchscheduling.domain.BatchSchedule;
import org.optaplanner.examples.batchscheduling.swingui.BatchSchedulingPanel;
import org.optaplanner.examples.common.app.CommonApp;
import org.optaplanner.examples.common.swingui.SolutionPanel;
import org.optaplanner.persistence.common.api.domain.solution.SolutionFileIO;
import org.optaplanner.persistence.xstream.impl.domain.solution.XStreamSolutionFileIO;

public class BatchSchedulingApp
extends CommonApp<BatchSchedule> {
    public static final String SOLVER_CONFIG = "org/optaplanner/examples/batchscheduling/solver/batchSchedulingSolverConfig.xml";
    public static final String DATA_DIR_NAME = "batchscheduling";
    public static final Integer FRACTIONAL_VOLUME_PERCENTAGE = 20;
    public static final Integer PERIODINTERVAL_IN_MINUTES = 5;
    public static final int SELECTED_ROUTEPATH_NON_ALLOCATION_PENALTY = 1;
    public static final int NON_SELECTED_ROUTEPATH_ALLOCATION_PENALTY = 1;
    public static final String ROUTE_PATH_SEPERATOR = "---";

    public static void main(String[] args) {
        BatchSchedulingApp.prepareSwingEnvironment();
        new BatchSchedulingApp().init();
    }

    @Override
    public SolutionFileIO<BatchSchedule> createSolutionFileIO() {
        return new XStreamSolutionFileIO(new Class[]{BatchSchedulingApp.class});
    }

    public BatchSchedulingApp() {
        super("Batch Scheduling", "Official competition name: commodity scheduling problem in a pipeline grid MRCMPSP)\n\nSchedule all batches.\n\nMinimize delivery time and maximize segments utilization.", SOLVER_CONFIG, DATA_DIR_NAME, "/org/optaplanner/examples/batchscheduling/swingui/batchSchedulingLogo.png");
    }

    @Override
    protected SolutionPanel<BatchSchedule> createSolutionPanel() {
        return new BatchSchedulingPanel();
    }
}

