/*
 * Decompiled with CFR 0.152.
 */
package org.smpp.charset;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.util.HashMap;
import java.util.logging.Logger;

public class Gsm7BitCharset
extends Charset {
    private boolean debug = false;
    protected static HashMap<String, Byte> defaultEncodeMap = new HashMap();
    protected static HashMap<Byte, String> defaultDecodeMap = new HashMap();
    protected static HashMap<String, Byte> extEncodeMap = new HashMap();
    protected static HashMap<Byte, String> extDecodeMap = new HashMap();
    private static final Object[][] gsmCharacters = new Object[][]{{"@", new Byte(0)}, {"\u00a3", new Byte(1)}, {"$", new Byte(2)}, {"\u00a5", new Byte(3)}, {"\u00e8", new Byte(4)}, {"\u00e9", new Byte(5)}, {"\u00f9", new Byte(6)}, {"\u00ec", new Byte(7)}, {"\u00f2", new Byte(8)}, {"\u00c7", new Byte(9)}, {"\n", new Byte(10)}, {"\u00d8", new Byte(11)}, {"\u00f8", new Byte(12)}, {"\r", new Byte(13)}, {"\u00c5", new Byte(14)}, {"\u00e5", new Byte(15)}, {"\u0394", new Byte(16)}, {"_", new Byte(17)}, {"\u03a6", new Byte(18)}, {"\u0393", new Byte(19)}, {"\u039b", new Byte(20)}, {"\u03a9", new Byte(21)}, {"\u03a0", new Byte(22)}, {"\u03a8", new Byte(23)}, {"\u03a3", new Byte(24)}, {"\u0398", new Byte(25)}, {"\u039e", new Byte(26)}, {"\u001b", new Byte(27)}, {"\u00c6", new Byte(28)}, {"\u00e6", new Byte(29)}, {"\u00df", new Byte(30)}, {"\u00c9", new Byte(31)}, {" ", new Byte(32)}, {"!", new Byte(33)}, {"\"", new Byte(34)}, {"#", new Byte(35)}, {"\u00a4", new Byte(36)}, {"%", new Byte(37)}, {"&", new Byte(38)}, {"'", new Byte(39)}, {"(", new Byte(40)}, {")", new Byte(41)}, {"*", new Byte(42)}, {"+", new Byte(43)}, {",", new Byte(44)}, {"-", new Byte(45)}, {".", new Byte(46)}, {"/", new Byte(47)}, {"0", new Byte(48)}, {"1", new Byte(49)}, {"2", new Byte(50)}, {"3", new Byte(51)}, {"4", new Byte(52)}, {"5", new Byte(53)}, {"6", new Byte(54)}, {"7", new Byte(55)}, {"8", new Byte(56)}, {"9", new Byte(57)}, {":", new Byte(58)}, {";", new Byte(59)}, {"<", new Byte(60)}, {"=", new Byte(61)}, {">", new Byte(62)}, {"?", new Byte(63)}, {"\u00a1", new Byte(64)}, {"A", new Byte(65)}, {"B", new Byte(66)}, {"C", new Byte(67)}, {"D", new Byte(68)}, {"E", new Byte(69)}, {"F", new Byte(70)}, {"G", new Byte(71)}, {"H", new Byte(72)}, {"I", new Byte(73)}, {"J", new Byte(74)}, {"K", new Byte(75)}, {"L", new Byte(76)}, {"M", new Byte(77)}, {"N", new Byte(78)}, {"O", new Byte(79)}, {"P", new Byte(80)}, {"Q", new Byte(81)}, {"R", new Byte(82)}, {"S", new Byte(83)}, {"T", new Byte(84)}, {"U", new Byte(85)}, {"V", new Byte(86)}, {"W", new Byte(87)}, {"X", new Byte(88)}, {"Y", new Byte(89)}, {"Z", new Byte(90)}, {"\u00c4", new Byte(91)}, {"\u00d6", new Byte(92)}, {"\u00d1", new Byte(93)}, {"\u00dc", new Byte(94)}, {"\u00a7", new Byte(95)}, {"\u00bf", new Byte(96)}, {"a", new Byte(97)}, {"b", new Byte(98)}, {"c", new Byte(99)}, {"d", new Byte(100)}, {"e", new Byte(101)}, {"f", new Byte(102)}, {"g", new Byte(103)}, {"h", new Byte(104)}, {"i", new Byte(105)}, {"j", new Byte(106)}, {"k", new Byte(107)}, {"l", new Byte(108)}, {"m", new Byte(109)}, {"n", new Byte(110)}, {"o", new Byte(111)}, {"p", new Byte(112)}, {"q", new Byte(113)}, {"r", new Byte(114)}, {"s", new Byte(115)}, {"t", new Byte(116)}, {"u", new Byte(117)}, {"v", new Byte(118)}, {"w", new Byte(119)}, {"x", new Byte(120)}, {"y", new Byte(121)}, {"z", new Byte(122)}, {"\u00e4", new Byte(123)}, {"\u00f6", new Byte(124)}, {"\u00f1", new Byte(125)}, {"\u00fc", new Byte(126)}, {"\u00e0", new Byte(127)}};
    private static final Object[][] gsmExtensionCharacters = new Object[][]{{"\n", new Byte(10)}, {"^", new Byte(20)}, {" ", new Byte(27)}, {"{", new Byte(40)}, {"}", new Byte(41)}, {"\\", new Byte(47)}, {"[", new Byte(60)}, {"~", new Byte(61)}, {"]", new Byte(62)}, {"|", new Byte(64)}, {"\u0080", new Byte(101)}};
    private static Logger logger = Logger.getLogger(Gsm7BitCharset.class.getName());

    protected Gsm7BitCharset(String canonical, String[] aliases) {
        super(canonical, aliases);
    }

    public CharsetEncoder newEncoder() {
        return new Gsm7BitEncoder(this);
    }

    public CharsetDecoder newDecoder() {
        return new Gsm7BitDecoder(this);
    }

    public boolean contains(Charset cs) {
        return false;
    }

    static {
        for (Object[] map : gsmCharacters) {
            defaultEncodeMap.put((String)map[0], (Byte)map[1]);
            defaultDecodeMap.put((Byte)map[1], (String)map[0]);
        }
        for (Object[] map : gsmExtensionCharacters) {
            extEncodeMap.put((String)map[0], (Byte)map[1]);
            extDecodeMap.put((Byte)map[1], (String)map[0]);
        }
    }

    private class Gsm7BitDecoder
    extends CharsetDecoder {
        Gsm7BitDecoder(Charset cs) {
            super(cs, 1.0f, 1.0f);
        }

        protected CoderResult decodeLoop(ByteBuffer bb, CharBuffer cb) {
            CoderResult cr = CoderResult.UNDERFLOW;
            while (bb.hasRemaining() && cb.hasRemaining()) {
                String s;
                byte b = bb.get();
                if (Gsm7BitCharset.this.debug) {
                    logger.finest("Looking up byte " + b);
                }
                if ((s = defaultDecodeMap.get(new Byte(b))) != null) {
                    char ch = s.charAt(0);
                    if (ch != '\u001b') {
                        if (Gsm7BitCharset.this.debug) {
                            logger.finest("Found string " + s);
                        }
                        cb.put(ch);
                        continue;
                    }
                    if (Gsm7BitCharset.this.debug) {
                        logger.finest("Found escape character");
                    }
                    if (!bb.hasRemaining()) continue;
                    b = bb.get();
                    s = extDecodeMap.get(new Byte(b));
                    if (s != null) {
                        if (Gsm7BitCharset.this.debug) {
                            logger.finest("Found extended string " + s);
                        }
                        ch = s.charAt(0);
                        cb.put(ch);
                        continue;
                    }
                    cb.put('?');
                    continue;
                }
                cb.put('?');
            }
            return cr;
        }
    }

    private class Gsm7BitEncoder
    extends CharsetEncoder {
        Gsm7BitEncoder(Charset cs) {
            super(cs, 1.0f, 2.0f);
        }

        protected CoderResult encodeLoop(CharBuffer cb, ByteBuffer bb) {
            CoderResult cr = CoderResult.UNDERFLOW;
            while (cb.hasRemaining() && bb.hasRemaining()) {
                char ch = cb.get();
                Byte b = defaultEncodeMap.get("" + ch);
                if (Gsm7BitCharset.this.debug) {
                    logger.finest("Encoding ch " + ch + " to byte " + b);
                }
                if (b != null) {
                    bb.put(b);
                    continue;
                }
                b = extEncodeMap.get("" + ch);
                if (Gsm7BitCharset.this.debug) {
                    logger.finest("Trying extended map to encode ch " + ch + " to byte " + b);
                }
                if (b != null) {
                    if (bb.remaining() < 2) {
                        cb.position(cb.position() - 1);
                        cr = CoderResult.OVERFLOW;
                        break;
                    }
                    bb.put((byte)27);
                    bb.put(b);
                    continue;
                }
                b = new Byte(63);
                bb.put(b);
            }
            return cr;
        }
    }
}

