/*
 * Decompiled with CFR 0.152.
 */
package org.openscada.opc.lib.da;

import org.openscada.opc.dcom.da.OPCSERVERSTATUS;
import org.openscada.opc.dcom.da.impl.OPCServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerStateOperation
implements Runnable {
    private static Logger _log = LoggerFactory.getLogger(ServerStateOperation.class);
    public OPCSERVERSTATUS _serverStatus = null;
    public OPCServer _server;
    public Throwable _error;
    public Object _lock = new Object();
    public boolean _running = false;

    public ServerStateOperation(OPCServer server) {
        this._server = server;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Object object = this._lock;
        synchronized (object) {
            this._running = true;
        }
        try {
            this._serverStatus = this._server.getStatus();
            object = this._lock;
            synchronized (object) {
                this._running = false;
                this._lock.notify();
            }
        }
        catch (Throwable e) {
            _log.info("Failed to get server state", e);
            this._error = e;
            this._running = false;
            Object object2 = this._lock;
            synchronized (object2) {
                this._lock.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OPCSERVERSTATUS getServerState(int timeout) throws Throwable {
        if (this._server == null) {
            _log.debug("No connection to server. Skipping...");
            return null;
        }
        Thread t = new Thread((Runnable)this, "OPCServerStateReader");
        Object object = this._lock;
        synchronized (object) {
            t.start();
            this._lock.wait(timeout);
            if (this._running) {
                _log.warn("State operation still running. Interrupting...");
                t.interrupt();
                throw new InterruptedException("Interrupted getting server state");
            }
        }
        if (this._error != null) {
            _log.warn("An error occurred while getting server state", this._error);
            throw this._error;
        }
        return this._serverStatus;
    }
}

