/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.xml.security;

import java.nio.file.Paths;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.marker.Marker;
import org.openrewrite.marker.SearchResult;
import org.openrewrite.xml.XmlIsoVisitor;
import org.openrewrite.xml.tree.Xml;

public class IsOwaspSuppressionsFile
extends Recipe {
    public String getDisplayName() {
        return "Find OWASP `suppressions.xml`";
    }

    public String getDescription() {
        return "These files are used to suppress false positives in OWASP [Dependency Check](https://jeremylong.github.io/DependencyCheck).";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new XmlIsoVisitor<ExecutionContext>(){

            @Override
            public Xml.Document visitDocument(Xml.Document document, ExecutionContext executionContext) {
                Xml doc = super.visitDocument(document, executionContext);
                if (!((Xml.Document)doc).getSourcePath().equals(Paths.get("suppressions.xml", new String[0])) || ((Xml.Document)doc).getRoot() == null) {
                    return doc;
                }
                Xml.Tag root = ((Xml.Document)doc).getRoot();
                if (!root.getName().equals("suppressions")) {
                    return doc;
                }
                boolean isOwaspSuppressionFile = false;
                for (Xml.Attribute attribute : root.getAttributes()) {
                    if (!attribute.getKeyAsString().equals("xmlns") || !attribute.getValueAsString().matches("https://jeremylong.github.io/DependencyCheck/dependency-suppression(.*?).xsd")) continue;
                    isOwaspSuppressionFile = true;
                }
                if (isOwaspSuppressionFile) {
                    return ((Xml.Document)doc).withRoot(((Xml.Document)doc).getRoot().withMarkers(((Xml.Document)doc).getRoot().getMarkers().addIfAbsent((Marker)new SearchResult(Tree.randomId(), "Found it"))));
                }
                return doc;
            }
        };
    }
}

