/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.python.internal;

import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.regex.Pattern;
import org.openrewrite.ExecutionContext;
import org.openrewrite.FileAttributes;
import org.openrewrite.internal.EncodingDetectingInputStream;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.internal.JavaTypeCache;
import org.openrewrite.java.tree.JLeftPadded;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.Space;
import org.openrewrite.marker.Markers;

public class PythonParserVisitor {
    private final Path sourcePath;
    @Nullable
    private final FileAttributes fileAttributes;
    private final String source;
    private final Charset charset;
    private final boolean charsetBomMarked;
    private final ExecutionContext ctx;
    private int cursor;
    private static final Pattern whitespaceSuffixPattern = Pattern.compile("\\s*[^\\s]+(\\s*)");

    public PythonParserVisitor(Path sourcePath, @Nullable FileAttributes fileAttributes, EncodingDetectingInputStream source, JavaTypeCache typeCache, ExecutionContext ctx) {
        this.sourcePath = sourcePath;
        this.fileAttributes = fileAttributes;
        this.source = source.readFully();
        this.charset = source.getCharset();
        this.charsetBomMarked = source.isCharsetBomMarked();
        this.ctx = ctx;
    }

    private <T> JLeftPadded<T> padLeft(Space left, T tree) {
        return new JLeftPadded(left, tree, Markers.EMPTY);
    }

    private <T> JRightPadded<T> padRight(T tree, @Nullable Space right) {
        return new JRightPadded(tree, right == null ? Space.EMPTY : right, Markers.EMPTY);
    }

    private int positionOfNext(String untilDelim) {
        return this.positionOfNext(untilDelim, null);
    }

    private int positionOfNext(String untilDelim, @Nullable Character stop) {
        int delimIndex;
        boolean inMultiLineComment = false;
        boolean inSingleLineComment = false;
        for (delimIndex = this.cursor; delimIndex < this.source.length() - untilDelim.length() + 1; ++delimIndex) {
            if (inSingleLineComment) {
                if (this.source.charAt(delimIndex) != '\n') continue;
                inSingleLineComment = false;
                continue;
            }
            if (this.source.length() - untilDelim.length() > delimIndex + 1) {
                char c1 = this.source.charAt(delimIndex);
                char c2 = this.source.charAt(delimIndex + 1);
                if (c1 == '/') {
                    if (c2 == '/') {
                        inSingleLineComment = true;
                        ++delimIndex;
                    } else if (c2 == '*') {
                        inMultiLineComment = true;
                        ++delimIndex;
                    }
                } else if (c1 == '*' && c2 == '/') {
                    inMultiLineComment = false;
                    delimIndex += 2;
                }
            }
            if (inMultiLineComment || inSingleLineComment) continue;
            if (stop != null && this.source.charAt(delimIndex) == stop.charValue()) {
                return -1;
            }
            if (this.source.startsWith(untilDelim, delimIndex)) break;
        }
        return delimIndex > this.source.length() - untilDelim.length() ? -1 : delimIndex;
    }

    private Space sourceBefore(String untilDelim) {
        int delimIndex = this.positionOfNext(untilDelim);
        if (delimIndex < 0) {
            return Space.EMPTY;
        }
        String prefix = this.source.substring(this.cursor, delimIndex);
        this.cursor += prefix.length() + untilDelim.length();
        return Space.format((String)prefix);
    }

    private Space sourceBefore(String untilDelim, @Nullable Character stop) {
        int delimIndex = this.positionOfNext(untilDelim, stop);
        if (delimIndex < 0) {
            return Space.EMPTY;
        }
        if (delimIndex == this.cursor) {
            this.cursor += untilDelim.length();
            return Space.EMPTY;
        }
        String prefix = this.source.substring(this.cursor, delimIndex);
        this.cursor += prefix.length() + untilDelim.length();
        return Space.format((String)prefix);
    }

    private Space whitespace() {
        String prefix = this.source.substring(this.cursor, StringUtils.indexOfNextNonWhitespace((int)this.cursor, (String)this.source));
        this.cursor += prefix.length();
        return Space.format((String)prefix);
    }
}

