/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic;

import com.intellij.diagnostic.Activity;
import com.intellij.diagnostic.ActivityCategory;
import com.intellij.diagnostic.ActivityImpl;
import com.intellij.diagnostic.LoadingState;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class StartUpMeasurer {
    static final AtomicReference<LoadingState> currentState = new AtomicReference<LoadingState>(LoadingState.BOOTSTRAP);
    public static final long MEASURE_THRESHOLD = TimeUnit.MILLISECONDS.toNanos(10L);
    public static boolean measuringPluginStartupCosts = true;
    private static long startTime = System.nanoTime();
    private static final Queue<ActivityImpl> items = new ConcurrentLinkedQueue<ActivityImpl>();
    private static boolean isEnabled = true;
    @ApiStatus.Internal
    public static final Map<String, Object2LongMap<String>> pluginCostMap = new ConcurrentHashMap<String, Object2LongMap<String>>();
    @ApiStatus.Internal
    public static volatile Activity appInitPreparationActivity;

    public static void stopPluginCostMeasurement() {
        measuringPluginStartupCosts = false;
    }

    public static boolean isEnabled() {
        return isEnabled;
    }

    @TestOnly
    public static void disable() {
        isEnabled = false;
    }

    public static long getCurrentTime() {
        return System.nanoTime();
    }

    public static long getCurrentTimeIfEnabled() {
        return isEnabled ? System.nanoTime() : -1L;
    }

    public static long sinceStart() {
        return TimeUnit.NANOSECONDS.toMillis(StartUpMeasurer.getCurrentTime() - startTime);
    }

    public static void addInstantEvent(@NonNls @NotNull String name) {
        if (name == null) {
            StartUpMeasurer.$$$reportNull$$$0(0);
        }
        if (!isEnabled) {
            return;
        }
        ActivityImpl activity = new ActivityImpl(name, StartUpMeasurer.getCurrentTime(), null, null);
        activity.setEnd(-1L);
        StartUpMeasurer.addActivity(activity);
    }

    @NotNull
    public static Activity startActivity(@NonNls @NotNull String name, @NotNull ActivityCategory category) {
        if (name == null) {
            StartUpMeasurer.$$$reportNull$$$0(1);
        }
        if (category == null) {
            StartUpMeasurer.$$$reportNull$$$0(2);
        }
        return new ActivityImpl(name, StartUpMeasurer.getCurrentTime(), null, null, category);
    }

    @NotNull
    public static Activity startActivity(@NonNls @NotNull String name) {
        if (name == null) {
            StartUpMeasurer.$$$reportNull$$$0(3);
        }
        return new ActivityImpl(name, StartUpMeasurer.getCurrentTime(), null, null, ActivityCategory.DEFAULT);
    }

    @NotNull
    public static Activity startActivity(@NonNls @NotNull String name, @NotNull ActivityCategory category, @Nullable String pluginId) {
        if (name == null) {
            StartUpMeasurer.$$$reportNull$$$0(4);
        }
        if (category == null) {
            StartUpMeasurer.$$$reportNull$$$0(5);
        }
        return new ActivityImpl(name, StartUpMeasurer.getCurrentTime(), null, pluginId, category);
    }

    /*
     * WARNING - void declaration
     */
    public static long addCompletedActivity(long start, @NotNull Class<?> clazz, @NotNull ActivityCategory category, @Nullable String string) {
        void pluginId;
        if (clazz == null) {
            StartUpMeasurer.$$$reportNull$$$0(6);
        }
        if (category == null) {
            StartUpMeasurer.$$$reportNull$$$0(7);
        }
        return StartUpMeasurer.addCompletedActivity(start, clazz, category, (String)pluginId, -1L);
    }

    /*
     * WARNING - void declaration
     */
    public static long addCompletedActivity(long start, @NotNull Class<?> clazz, @NotNull ActivityCategory category, @Nullable String pluginId, long l) {
        void threshold;
        if (clazz == null) {
            StartUpMeasurer.$$$reportNull$$$0(8);
        }
        if (category == null) {
            StartUpMeasurer.$$$reportNull$$$0(9);
        }
        if (!isEnabled) {
            return -1L;
        }
        long end = StartUpMeasurer.getCurrentTime();
        long duration = end - start;
        if (duration <= threshold) {
            return duration;
        }
        StartUpMeasurer.addCompletedActivity(start, end, clazz.getName(), category, pluginId);
        return duration;
    }

    /*
     * WARNING - void declaration
     */
    public static long addCompletedActivity(long start, @NonNls @NotNull String name, @NotNull ActivityCategory category, String string) {
        void pluginId;
        long end;
        long duration;
        if (name == null) {
            StartUpMeasurer.$$$reportNull$$$0(10);
        }
        if (category == null) {
            StartUpMeasurer.$$$reportNull$$$0(11);
        }
        if ((duration = (end = StartUpMeasurer.getCurrentTime()) - start) <= MEASURE_THRESHOLD) {
            return duration;
        }
        StartUpMeasurer.addCompletedActivity(start, end, name, category, (String)pluginId);
        return duration;
    }

    /*
     * WARNING - void declaration
     */
    public static void addCompletedActivity(long start, long end, @NonNls @NotNull String name, @NotNull ActivityCategory activityCategory, String string) {
        void category;
        void pluginId;
        if (name == null) {
            StartUpMeasurer.$$$reportNull$$$0(12);
        }
        if (activityCategory == null) {
            StartUpMeasurer.$$$reportNull$$$0(13);
        }
        if (!isEnabled) {
            return;
        }
        ActivityImpl item = new ActivityImpl(name, start, null, (String)pluginId, (ActivityCategory)category);
        item.setEnd(end);
        StartUpMeasurer.addActivity(item);
    }

    public static void setCurrentState(@NotNull LoadingState state) {
        BiConsumer<String, Throwable> errorHandler;
        LoadingState old;
        if (state == null) {
            StartUpMeasurer.$$$reportNull$$$0(14);
        }
        if ((old = currentState.getAndSet(state)).compareTo(state) > 0 && (errorHandler = LoadingState.errorHandler) != null) {
            errorHandler.accept("New state " + (Object)((Object)state) + " cannot precede old " + (Object)((Object)old), new Throwable());
        }
        StartUpMeasurer.stateSet(state);
    }

    public static void compareAndSetCurrentState(@NotNull LoadingState expectedState, @NotNull LoadingState newState) {
        if (expectedState == null) {
            StartUpMeasurer.$$$reportNull$$$0(15);
        }
        if (newState == null) {
            StartUpMeasurer.$$$reportNull$$$0(16);
        }
        if (currentState.compareAndSet(expectedState, newState)) {
            StartUpMeasurer.stateSet(newState);
        }
    }

    private static void stateSet(@NotNull LoadingState state) {
        if (state == null) {
            StartUpMeasurer.$$$reportNull$$$0(17);
        }
        StartUpMeasurer.addInstantEvent(state.displayName);
    }

    @ApiStatus.Internal
    public static void processAndClear(boolean isContinueToCollect, @NotNull Consumer<? super ActivityImpl> consumer) {
        ActivityImpl item;
        if (consumer == null) {
            StartUpMeasurer.$$$reportNull$$$0(18);
        }
        isEnabled = isContinueToCollect;
        while ((item = items.poll()) != null) {
            consumer.accept((ActivityImpl)item);
        }
    }

    @ApiStatus.Internal
    public static long getStartTime() {
        return startTime;
    }

    static void addActivity(@NotNull ActivityImpl activity) {
        if (activity == null) {
            StartUpMeasurer.$$$reportNull$$$0(19);
        }
        if (isEnabled) {
            items.add(activity);
        }
    }

    @ApiStatus.Internal
    public static void addTimings(@NotNull LinkedHashMap<String, Long> timings, @NotNull String groupName) {
        if (timings == null) {
            StartUpMeasurer.$$$reportNull$$$0(20);
        }
        if (groupName == null) {
            StartUpMeasurer.$$$reportNull$$$0(21);
        }
        if (!items.isEmpty()) {
            throw new IllegalStateException("addTimings must be not called if some events were already added using API");
        }
        if (timings.isEmpty()) {
            return;
        }
        ArrayList<Map.Entry<String, Long>> entries = new ArrayList<Map.Entry<String, Long>>(timings.entrySet());
        ActivityImpl parent = new ActivityImpl(groupName, ((Long)((Map.Entry)entries.get(0)).getValue()).longValue(), null, null);
        parent.setEnd(StartUpMeasurer.getCurrentTime());
        for (int i = 0; i < entries.size(); ++i) {
            long start = (Long)((Map.Entry)entries.get(i)).getValue();
            if (start < startTime) {
                startTime = start;
            }
            ActivityImpl activity = new ActivityImpl((String)((Map.Entry)entries.get(i)).getKey(), start, parent, null);
            activity.setEnd(i == entries.size() - 1 ? parent.getEnd() : ((Long)((Map.Entry)entries.get(i + 1)).getValue()).longValue());
            items.add(activity);
        }
        items.add(parent);
    }

    @ApiStatus.Internal
    public static void addPluginCost(@NonNls @NotNull String pluginId, @NonNls @NotNull String phase, long time) {
        if (pluginId == null) {
            StartUpMeasurer.$$$reportNull$$$0(22);
        }
        if (phase == null) {
            StartUpMeasurer.$$$reportNull$$$0(23);
        }
        if (StartUpMeasurer.isMeasuringPluginStartupCosts()) {
            StartUpMeasurer.doAddPluginCost(pluginId, phase, time, pluginCostMap);
        }
    }

    public static boolean isMeasuringPluginStartupCosts() {
        return measuringPluginStartupCosts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @ApiStatus.Internal
    public static void doAddPluginCost(@NonNls @NotNull String pluginId, @NonNls @NotNull String phase, long time, @NotNull Map<String, Object2LongMap<String>> map) {
        void pluginCostMap;
        Object2LongMap costPerPhaseMap;
        if (pluginId == null) {
            StartUpMeasurer.$$$reportNull$$$0(24);
        }
        if (phase == null) {
            StartUpMeasurer.$$$reportNull$$$0(25);
        }
        if (map == null) {
            StartUpMeasurer.$$$reportNull$$$0(26);
        }
        Object2LongMap object2LongMap = costPerPhaseMap = pluginCostMap.computeIfAbsent(pluginId, __ -> new Object2LongOpenHashMap());
        synchronized (object2LongMap) {
            costPerPhaseMap.mergeLong((Object)phase, time, Math::addExact);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "category";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedState";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newState";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "activity";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "timings";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupName";
                break;
            }
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginId";
                break;
            }
            case 23: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "phase";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginCostMap";
                break;
            }
        }
        objectArray2[1] = "com/intellij/diagnostic/StartUpMeasurer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "addInstantEvent";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "startActivity";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "addCompletedActivity";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "setCurrentState";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "compareAndSetCurrentState";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "stateSet";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[2] = "processAndClear";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[2] = "addActivity";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[2] = "addTimings";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[2] = "addPluginCost";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[2] = "doAddPluginCost";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

