/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.recipes;

import java.util.Collections;
import java.util.Set;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.recipes.MigrateRecipeToRewrite8;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.TypeUtils;

public class MigrateMarkersSearchResult
extends Recipe {
    private static final MethodMatcher WITH_MARKERS_METHOD_MATCHER = new MethodMatcher("org.openrewrite.yaml.tree.Yaml.Mapping.Entry withMarkers(org.openrewrite.marker.Markers)");
    private static final MethodMatcher SEARCH_RESULT_METHOD_MATCHER = new MethodMatcher("org.openrewrite.marker.Markers searchResult(java.lang.String)");
    private static final MethodMatcher GET_MARKERS_METHOD_MATCHER = new MethodMatcher("org.openrewrite.yaml.tree.Yaml.Mapping.Entry getMarkers()");
    private static final String MANUAL_CHANGE_COMMENT = " [Rewrite8 migration] `org.openrewrite.marker.Markers#SearchResult(..)` are deprecated and removed in rewrite 8, use `SearchResult.found()` instead.please follow the migration guide here: https://docs.openrewrite.org/changelog/8-1-2-release";

    public String getDisplayName() {
        return "Migrate deprecated `org.openrewrite.marker.Markers#SearchResult(..)`";
    }

    public String getDescription() {
        return "Methods of `org.openrewrite.marker.Markers#SearchResult(..)` are deprecated and removed in rewrite 8, use `SearchResult.found()` instead.";
    }

    public Set<String> getTags() {
        return Collections.singleton("Rewrite8 migration");
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new JavaIsoVisitor<ExecutionContext>(){

            @Override
            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext executionContext) {
                if (((J.MethodInvocation)(method = super.visitMethodInvocation((J.MethodInvocation)method, executionContext))).getSimpleName().equals("withMarkers") && ((J.MethodInvocation)method).getSelect() != null && TypeUtils.isOfClassType(((J.MethodInvocation)method).getSelect().getType(), "org.openrewrite.yaml.tree.Yaml.Mapping.Entry")) {
                    J.MethodInvocation m;
                    Expression select = ((J.MethodInvocation)method).getSelect();
                    if (((J.MethodInvocation)method).getArguments().isEmpty()) {
                        return method;
                    }
                    Expression arg = ((J.MethodInvocation)method).getArguments().get(0);
                    if (arg instanceof J.MethodInvocation && (m = (J.MethodInvocation)arg).getSimpleName().equals("searchResult") && m.getSelect() != null && TypeUtils.isOfClassType(m.getSelect().getType(), "org.openrewrite.marker.Markers")) {
                        Expression text = m.getArguments().get(0);
                        Expression searchResultSelect = m.getSelect();
                        if (searchResultSelect instanceof J.MethodInvocation) {
                            J.MethodInvocation maybeGetMarkers = (J.MethodInvocation)searchResultSelect;
                            if (GET_MARKERS_METHOD_MATCHER.matches(maybeGetMarkers)) {
                                Expression s2 = maybeGetMarkers.getSelect();
                                if (select instanceof J.Identifier && s2 instanceof J.Identifier) {
                                    J.Identifier id1 = (J.Identifier)select;
                                    J.Identifier id2 = (J.Identifier)s2;
                                    if (!id1.getSimpleName().equals(id2.getSimpleName())) {
                                        return (J.MethodInvocation)MigrateRecipeToRewrite8.commentOf(method, MigrateMarkersSearchResult.MANUAL_CHANGE_COMMENT);
                                    }
                                    this.maybeAddImport("org.openrewrite.marker.SearchResult");
                                    JavaTemplate searchResultTemplate = JavaTemplate.builder("SearchResult.found(#{any()}, #{any()})").javaParser((JavaParser.Builder<?, ?>)((Object)JavaParser.fromJavaVersion().classpath(JavaParser.runtimeClasspath()))).imports("org.openrewrite.marker.SearchResult").build();
                                    return (J.MethodInvocation)searchResultTemplate.apply(this.updateCursor(method), ((J.MethodInvocation)method).getCoordinates().replace(), select, text);
                                }
                            }
                        }
                        return (J.MethodInvocation)MigrateRecipeToRewrite8.commentOf(method, MigrateMarkersSearchResult.MANUAL_CHANGE_COMMENT);
                    }
                    return method;
                }
                return method;
            }
        };
    }
}

