/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.cleanup;

import java.util.Iterator;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.J;

public class UseForEachRemoveInsteadOfSetRemoveAll
extends Recipe {
    public String getDisplayName() {
        return "Replace `java.util.Set#removeAll(java.util.Collection)` with `java.util.Collection#forEach(Set::remove)`";
    }

    public String getDescription() {
        return "Using `java.util.Collection#forEach(Set::remove)` rather than `java.util.Set#removeAll(java.util.Collection)` may improve performance due to a possible O(n^2) complexity.";
    }

    protected UsesMethod<ExecutionContext> getSingleSourceApplicableTest() {
        return new UsesMethod<ExecutionContext>(new MethodMatcher("java.util.Set removeAll(java.util.Collection)"));
    }

    protected JavaIsoVisitor<ExecutionContext> getVisitor() {
        return new JavaIsoVisitor<ExecutionContext>(){
            final MethodMatcher rmaMatcher = new MethodMatcher("java.util.Set removeAll(java.util.Collection)");

            @Override
            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext executionContext) {
                J mi = super.visitMethodInvocation(method, executionContext);
                if (this.rmaMatcher.matches((J.MethodInvocation)mi) && !this.returnValueIsUsed()) {
                    mi = (J.MethodInvocation)mi.withTemplate(JavaTemplate.builder(() -> this.getCursor().getParentOrThrow(), "#{any(java.util.Collection)}.forEach(#{any(java.util.Set)}::remove)").build(), ((J.MethodInvocation)mi).getCoordinates().replace(), ((J.MethodInvocation)mi).getArguments().get(0), ((J.MethodInvocation)mi).getSelect());
                }
                return mi;
            }

            private boolean returnValueIsUsed() {
                Iterator cIterator = this.getCursor().getPathAsCursors();
                while (cIterator.hasNext()) {
                    Cursor p = (Cursor)cIterator.next();
                    if (p.getValue() instanceof J.ClassDeclaration || p.getValue() instanceof J.Block || p.getValue() instanceof J.Lambda) {
                        return false;
                    }
                    if (!(p.getValue() instanceof J.ControlParentheses) && !(p.getValue() instanceof J.Return) && !(p.getValue() instanceof J.VariableDeclarations) && !(p.getValue() instanceof J.Assignment)) continue;
                    return true;
                }
                return true;
            }
        };
    }
}

