/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.cleanup;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.MethodCall;

public class ReplaceValidateNotNullHavingVarargsWithObjectsRequireNonNull
extends Recipe {
    private static final MethodMatcher VALIDATE_NOTNULL = new MethodMatcher("org.apache.commons.lang3.Validate notNull(Object, String, Object[])");

    public String getDisplayName() {
        return "Replace `org.apache.commons.lang3.Validate#notNull` with `Objects#requireNonNull`";
    }

    public String getDescription() {
        return "Replace `org.apache.commons.lang3.Validate.notNull(Object, String, Object[])` with `Objects.requireNonNull(Object, String)`.";
    }

    protected TreeVisitor<?, ExecutionContext> getSingleSourceApplicableTest() {
        return new UsesMethod<ExecutionContext>(VALIDATE_NOTNULL);
    }

    protected JavaVisitor<ExecutionContext> getVisitor() {
        return new JavaVisitor<ExecutionContext>(){

            @Override
            public J visitMethodInvocation(J.MethodInvocation method, ExecutionContext p) {
                J.MethodInvocation mi = (J.MethodInvocation)super.visitMethodInvocation(method, p);
                if (!VALIDATE_NOTNULL.matches(mi)) {
                    return mi;
                }
                List<Expression> arguments = mi.getArguments();
                String template = arguments.size() == 2 ? "Objects.requireNonNull(#{any()}, #{any(java.lang.String)})" : String.format("Objects.requireNonNull(#{any()}, () -> String.format(#{any(java.lang.String)}, %s))", String.join((CharSequence)", ", Collections.nCopies(arguments.size() - 2, "#{any()}")));
                this.maybeRemoveImport("org.apache.commons.lang3.Validate");
                this.maybeAddImport("java.util.Objects");
                mi = (J.MethodInvocation)mi.withTemplate(JavaTemplate.builder(() -> (this).getCursor(), template).imports("java.util.Objects").build(), mi.getCoordinates().replace(), arguments.toArray());
                if (arguments.size() == 2) {
                    return this.maybeAutoFormat(mi, mi.withArguments(ListUtils.map(mi.getArguments(), (a, b) -> (Expression)b.withPrefix(((Expression)arguments.get((int)a)).getPrefix()))), p);
                }
                Expression arg0 = arguments.get(0);
                arguments.remove(0);
                J.Lambda lambda = (J.Lambda)mi.getArguments().get(1);
                MethodCall stringFormatMi = (J.MethodInvocation)lambda.getBody();
                stringFormatMi = stringFormatMi.withArguments(ListUtils.map(stringFormatMi.getArguments(), (a, b) -> (Expression)b.withPrefix(((Expression)arguments.get((int)a)).getPrefix())));
                lambda = this.maybeAutoFormat(lambda, lambda.withBody(stringFormatMi), p);
                return this.maybeAutoFormat(mi, mi.withArguments(Stream.of(arg0, lambda).collect(Collectors.toList())), p);
            }
        };
    }
}

