/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.cleanup;

import java.time.Duration;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;

public class IsEmptyCallOnCollections
extends Recipe {
    private static final MethodMatcher COLLECTION_SIZE = new MethodMatcher("java.util.Collection size()", true);

    public String getDisplayName() {
        return "Use `Collection#isEmpty()` instead of comparing `size()`";
    }

    public String getDescription() {
        return "Also check for _not_ `isEmpty()` when testing for not equal to zero size.";
    }

    public Set<String> getTags() {
        return new LinkedHashSet<String>(Arrays.asList("RSPEC-1155", "RSPEC-3981"));
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(2L);
    }

    protected TreeVisitor<?, ExecutionContext> getSingleSourceApplicableTest() {
        return new UsesMethod<ExecutionContext>(COLLECTION_SIZE);
    }

    public JavaVisitor<ExecutionContext> getVisitor() {
        return new JavaVisitor<ExecutionContext>(){
            final JavaTemplate isEmpty = JavaTemplate.builder(() -> (this).getCursor(), "#{}#{any(java.util.Collection)}.isEmpty()").build();
            final JavaTemplate isEmptyNoReceiver = JavaTemplate.builder(() -> (this).getCursor(), "#{}isEmpty()").build();

            @Override
            public J visitBinary(J.Binary binary, ExecutionContext ctx) {
                if (IsEmptyCallOnCollections.isZero(binary.getLeft()) || IsEmptyCallOnCollections.isZero(binary.getRight())) {
                    Expression maybeSizeCall;
                    boolean zeroRight = IsEmptyCallOnCollections.isZero(binary.getRight());
                    Expression expression = maybeSizeCall = zeroRight ? binary.getLeft() : binary.getRight();
                    if ((binary.getOperator() == J.Binary.Type.Equal || binary.getOperator() == J.Binary.Type.NotEqual || zeroRight && binary.getOperator() == J.Binary.Type.GreaterThan || !zeroRight && binary.getOperator() == J.Binary.Type.LessThan) && maybeSizeCall instanceof J.MethodInvocation) {
                        J.MethodInvocation maybeSizeCallMethod = (J.MethodInvocation)maybeSizeCall;
                        if (COLLECTION_SIZE.matches(maybeSizeCallMethod)) {
                            String op = binary.getOperator() == J.Binary.Type.Equal ? "" : "!";
                            return (maybeSizeCallMethod.getSelect() == null ? binary.withTemplate(this.isEmptyNoReceiver, binary.getCoordinates().replace(), op) : binary.withTemplate(this.isEmpty, binary.getCoordinates().replace(), op, maybeSizeCallMethod.getSelect())).withPrefix(binary.getPrefix());
                        }
                    }
                }
                return super.visitBinary(binary, ctx);
            }
        };
    }

    private static boolean isZero(Expression expression) {
        return expression instanceof J.Literal && Integer.valueOf(0).equals(((J.Literal)expression).getValue());
    }
}

