/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.cleanup;

import java.time.Duration;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.cleanup.ModifierOrder;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.marker.Marker;
import org.openrewrite.marker.Markers;

public final class FixSerializableFields
extends Recipe {
    private static final SerializedMarker SERIALIZED_MARKER = new SerializedMarker(Tree.randomId());
    @Option(displayName="Mark fields as transient", description="Mark any fields that are not serializable as transient")
    private final Boolean markAllAsTransient;
    @Option(displayName="Fully-qualified exclusions", description="A list of fully-qualified names that should always be marked as transient vs being made `Serializable`", example="org.example.BeanFactory", required=false)
    @Nullable
    private final List<String> fullyQualifiedExclusions;

    public String getDisplayName() {
        return "Fields in a `Serializable` class should either be transient or serializable";
    }

    public String getDescription() {
        return "The fields of a class that implements `Serializable` must also implement `Serializable` or be marked as `transient`.\n\nThis recipe will look for any classes that directly or indirectly implement `Serializable` and for any member fields that are not serializable it will do one of two things:\n\n- If a non-serializable field has a type that is represented by a `SourceFile` within the same project, that SourceFile will be changed to implement `Serializable`.\n\n- If a non-serializable field has a type that is not represented as a `SourceFile`, the field will be marked as `transient`\n\nNOTE: If `markAllAsTransient` is set to `true`, this recipe will mark all non-serializable fields as `transient`.\n\nNOTE: Any fullyQualified names listed in the `fullyQualifiedExclusions` will be marked as transient, even if that SourceFile exists in the same project.\n\nNOTE: This recipe does NOT recursively modify newly `Serilazable` classes to cut down on the graph of SourceFiles that may be impacted during a recipe run.";
    }

    public Set<String> getTags() {
        return Collections.singleton("RSPEC-1948");
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(30L);
    }

    protected List<SourceFile> visit(List<SourceFile> before, ExecutionContext ctx) {
        HashSet<String> serializableTargets = new HashSet<String>();
        if (this.markAllAsTransient == null || !this.markAllAsTransient.booleanValue()) {
            final HashSet serializableCandidates = new HashSet();
            FindSerializableCandidatesVisitor candidateSearchVisitor = new FindSerializableCandidatesVisitor();
            for (SourceFile s2 : before) {
                candidateSearchVisitor.visit((Tree)s2, serializableCandidates);
            }
            if (!serializableCandidates.isEmpty()) {
                JavaIsoVisitor<Set<String>> findSerializableTargets = new JavaIsoVisitor<Set<String>>(){

                    @Override
                    public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, Set<String> targets) {
                        String fqn;
                        String string = fqn = classDecl.getType() == null ? "" : classDecl.getType().getFullyQualifiedName();
                        if ((FixSerializableFields.this.fullyQualifiedExclusions == null || !FixSerializableFields.this.fullyQualifiedExclusions.contains(fqn)) && serializableCandidates.contains(fqn)) {
                            targets.add(fqn);
                        }
                        return super.visitClassDeclaration(classDecl, targets);
                    }
                };
                for (SourceFile s3 : before) {
                    findSerializableTargets.visit((Tree)s3, serializableTargets);
                }
            }
        }
        FixSerializableClassVisitor fixSerializableClassVisitor = new FixSerializableClassVisitor(serializableTargets);
        return ListUtils.map(before, s -> {
            if (!(s instanceof J) && s.getMarkers().findFirst(SerializedMarker.class).isPresent()) {
                return s;
            }
            return (SourceFile)fixSerializableClassVisitor.visit((Tree)s, ctx);
        });
    }

    private static boolean implementsSerializable(@Nullable JavaType type) {
        return FixSerializableFields.implementsSerializable(type, null);
    }

    private static boolean implementsSerializable(@Nullable JavaType type, @Nullable Consumer<String> notSerializableAction) {
        JavaType.Parameterized parameterized;
        if (type == null) {
            return false;
        }
        if (type instanceof JavaType.Primitive) {
            return true;
        }
        if (type instanceof JavaType.Array) {
            return FixSerializableFields.implementsSerializable(((JavaType.Array)type).getElemType(), notSerializableAction);
        }
        if (type instanceof JavaType.Parameterized && (TypeUtils.isAssignableTo("java.util.Collection", (JavaType)(parameterized = (JavaType.Parameterized)type)) || TypeUtils.isAssignableTo("java.util.Map", (JavaType)parameterized))) {
            boolean typeParametersSerializable = true;
            for (JavaType typeParameter : parameterized.getTypeParameters()) {
                typeParametersSerializable = typeParametersSerializable && FixSerializableFields.implementsSerializable(typeParameter, notSerializableAction);
            }
            return typeParametersSerializable;
        }
        JavaType.FullyQualified fq = TypeUtils.asFullyQualified(type);
        if (TypeUtils.isAssignableTo("java.io.Serializable", type)) {
            return true;
        }
        if (fq != null && notSerializableAction != null) {
            notSerializableAction.accept(fq.getFullyQualifiedName());
        }
        return false;
    }

    public FixSerializableFields(Boolean markAllAsTransient, @Nullable List<String> fullyQualifiedExclusions) {
        this.markAllAsTransient = markAllAsTransient;
        this.fullyQualifiedExclusions = fullyQualifiedExclusions;
    }

    public Boolean getMarkAllAsTransient() {
        return this.markAllAsTransient;
    }

    @Nullable
    public List<String> getFullyQualifiedExclusions() {
        return this.fullyQualifiedExclusions;
    }

    @NonNull
    public String toString() {
        return "FixSerializableFields(markAllAsTransient=" + this.getMarkAllAsTransient() + ", fullyQualifiedExclusions=" + this.getFullyQualifiedExclusions() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FixSerializableFields)) {
            return false;
        }
        FixSerializableFields other = (FixSerializableFields)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$markAllAsTransient = this.getMarkAllAsTransient();
        Boolean other$markAllAsTransient = other.getMarkAllAsTransient();
        if (this$markAllAsTransient == null ? other$markAllAsTransient != null : !((Object)this$markAllAsTransient).equals(other$markAllAsTransient)) {
            return false;
        }
        List<String> this$fullyQualifiedExclusions = this.getFullyQualifiedExclusions();
        List<String> other$fullyQualifiedExclusions = other.getFullyQualifiedExclusions();
        return !(this$fullyQualifiedExclusions == null ? other$fullyQualifiedExclusions != null : !((Object)this$fullyQualifiedExclusions).equals(other$fullyQualifiedExclusions));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof FixSerializableFields;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $markAllAsTransient = this.getMarkAllAsTransient();
        result = result * 59 + ($markAllAsTransient == null ? 43 : ((Object)$markAllAsTransient).hashCode());
        List<String> $fullyQualifiedExclusions = this.getFullyQualifiedExclusions();
        result = result * 59 + ($fullyQualifiedExclusions == null ? 43 : ((Object)$fullyQualifiedExclusions).hashCode());
        return result;
    }

    private static final class SerializedMarker
    implements Marker {
        private final UUID id;

        public SerializedMarker(UUID id) {
            this.id = id;
        }

        public UUID getId() {
            return this.id;
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SerializedMarker)) {
                return false;
            }
            SerializedMarker other = (SerializedMarker)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @NonNull
        public String toString() {
            return "FixSerializableFields.SerializedMarker(id=" + this.getId() + ")";
        }

        @NonNull
        public SerializedMarker withId(UUID id) {
            return this.id == id ? this : new SerializedMarker(id);
        }
    }

    private static class FindSerializableCandidatesVisitor
    extends JavaVisitor<Set<String>> {
        private FindSerializableCandidatesVisitor() {
        }

        @Override
        public J visitClassDeclaration(J.ClassDeclaration classDecl, Set<String> candidates) {
            J.ClassDeclaration c = (J.ClassDeclaration)this.visitAndCast(classDecl, candidates, (x$0, x$1) -> super.visitClassDeclaration((J.ClassDeclaration)x$0, x$1));
            if (FixSerializableFields.implementsSerializable(c.getType())) {
                for (Statement s : classDecl.getBody().getStatements()) {
                    JavaType.FullyQualified fq;
                    J.VariableDeclarations variableDeclarations;
                    if (!(s instanceof J.VariableDeclarations) || (variableDeclarations = (J.VariableDeclarations)s).hasModifier(J.Modifier.Type.Transient) || variableDeclarations.hasModifier(J.Modifier.Type.Static)) continue;
                    JavaType variableType = variableDeclarations.getType();
                    if (variableDeclarations.getTypeExpression() instanceof J.ParameterizedType && !variableDeclarations.getVariables().isEmpty()) {
                        variableType = variableDeclarations.getVariables().get(0).getType();
                    }
                    String typeName = (fq = TypeUtils.asFullyQualified(variableType)) == null ? "" : fq.getFullyQualifiedName();
                    FixSerializableFields.implementsSerializable(variableType, candidates::add);
                }
            }
            return c;
        }
    }

    private static class FixSerializableClassVisitor
    extends JavaVisitor<ExecutionContext> {
        private final Set<String> targets;

        @Override
        public J visitClassDeclaration(J.ClassDeclaration classDecl, ExecutionContext ctx) {
            J.ClassDeclaration after;
            J.ClassDeclaration c = (J.ClassDeclaration)this.visitAndCast(classDecl, ctx, (x$0, x$1) -> super.visitClassDeclaration((J.ClassDeclaration)x$0, x$1));
            JavaType.FullyQualified fullyQualified = TypeUtils.asFullyQualified(c.getType());
            boolean isClassSerializable = FixSerializableFields.implementsSerializable(c.getType());
            if (!isClassSerializable && fullyQualified != null && this.targets.contains(fullyQualified.getFullyQualifiedName())) {
                this.maybeAddImport("java.io.Serializable");
                return c.withTemplate(JavaTemplate.builder(() -> ((FixSerializableClassVisitor)this).getCursor(), "Serializable").imports("java.io.Serializable").build(), c.getCoordinates().addImplementsClause(), new Object[0]);
            }
            if (isClassSerializable && (after = c.withBody(c.getBody().withStatements(ListUtils.map(classDecl.getBody().getStatements(), s -> {
                J.VariableDeclarations variableDeclarations;
                if (s instanceof J.VariableDeclarations && !(variableDeclarations = (J.VariableDeclarations)s).hasModifier(J.Modifier.Type.Transient) && !variableDeclarations.hasModifier(J.Modifier.Type.Static)) {
                    AtomicBoolean markAsTransient;
                    JavaType variableType = variableDeclarations.getType();
                    if (variableDeclarations.getTypeExpression() instanceof J.ParameterizedType && !variableDeclarations.getVariables().isEmpty()) {
                        variableType = variableDeclarations.getVariables().get(0).getType();
                    }
                    if (!FixSerializableFields.implementsSerializable(variableType, arg_0 -> this.lambda$visitClassDeclaration$1(markAsTransient = new AtomicBoolean(true), arg_0)) && markAsTransient.get()) {
                        return this.autoFormat(variableDeclarations.withModifiers(ModifierOrder.sortModifiers(ListUtils.concat(variableDeclarations.getModifiers(), (Object)new J.Modifier(Tree.randomId(), Space.EMPTY, Markers.EMPTY, J.Modifier.Type.Transient, Collections.emptyList())))), ctx).withPrefix(variableDeclarations.getPrefix());
                    }
                }
                return s;
            })))) != c) {
                return after.withMarkers(after.getMarkers().addIfAbsent((Marker)SERIALIZED_MARKER));
            }
            return c;
        }

        public FixSerializableClassVisitor(Set<String> targets) {
            this.targets = targets;
        }

        private /* synthetic */ void lambda$visitClassDeclaration$1(AtomicBoolean markAsTransient, String fqn) {
            markAsTransient.set(markAsTransient.get() && !this.targets.contains(fqn));
        }
    }
}

