/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;

public final class ReplaceConstantWithAnotherConstant
extends Recipe {
    @Option(displayName="Fully qualified name of the constant to replace", example="org.springframework.http.MediaType.APPLICATION_JSON_VALUE")
    private final String existingFullyQualifiedConstantName;
    @Option(displayName="Fully qualified name of the constant to use in place of existing constant", example="org.springframework.http.MediaType.APPLICATION_JSON_VALUE")
    private final String fullyQualifiedConstantName;

    public String getDisplayName() {
        return "Replace constant with another constant";
    }

    public String getDescription() {
        return "Replace constant with another constant, adding/removing import on class if needed.";
    }

    protected TreeVisitor<?, ExecutionContext> getSingleSourceApplicableTest() {
        return new UsesType<ExecutionContext>(this.existingFullyQualifiedConstantName.substring(0, this.existingFullyQualifiedConstantName.lastIndexOf(46)), false);
    }

    public JavaVisitor<ExecutionContext> getVisitor() {
        return new ReplaceConstantWithAnotherConstantVisitor(this.existingFullyQualifiedConstantName, this.fullyQualifiedConstantName);
    }

    public ReplaceConstantWithAnotherConstant(String existingFullyQualifiedConstantName, String fullyQualifiedConstantName) {
        this.existingFullyQualifiedConstantName = existingFullyQualifiedConstantName;
        this.fullyQualifiedConstantName = fullyQualifiedConstantName;
    }

    public String getExistingFullyQualifiedConstantName() {
        return this.existingFullyQualifiedConstantName;
    }

    public String getFullyQualifiedConstantName() {
        return this.fullyQualifiedConstantName;
    }

    @NonNull
    public String toString() {
        return "ReplaceConstantWithAnotherConstant(existingFullyQualifiedConstantName=" + this.getExistingFullyQualifiedConstantName() + ", fullyQualifiedConstantName=" + this.getFullyQualifiedConstantName() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ReplaceConstantWithAnotherConstant)) {
            return false;
        }
        ReplaceConstantWithAnotherConstant other = (ReplaceConstantWithAnotherConstant)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$existingFullyQualifiedConstantName = this.getExistingFullyQualifiedConstantName();
        String other$existingFullyQualifiedConstantName = other.getExistingFullyQualifiedConstantName();
        if (this$existingFullyQualifiedConstantName == null ? other$existingFullyQualifiedConstantName != null : !this$existingFullyQualifiedConstantName.equals(other$existingFullyQualifiedConstantName)) {
            return false;
        }
        String this$fullyQualifiedConstantName = this.getFullyQualifiedConstantName();
        String other$fullyQualifiedConstantName = other.getFullyQualifiedConstantName();
        return !(this$fullyQualifiedConstantName == null ? other$fullyQualifiedConstantName != null : !this$fullyQualifiedConstantName.equals(other$fullyQualifiedConstantName));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ReplaceConstantWithAnotherConstant;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $existingFullyQualifiedConstantName = this.getExistingFullyQualifiedConstantName();
        result = result * 59 + ($existingFullyQualifiedConstantName == null ? 43 : $existingFullyQualifiedConstantName.hashCode());
        String $fullyQualifiedConstantName = this.getFullyQualifiedConstantName();
        result = result * 59 + ($fullyQualifiedConstantName == null ? 43 : $fullyQualifiedConstantName.hashCode());
        return result;
    }

    private static class ReplaceConstantWithAnotherConstantVisitor
    extends JavaVisitor<ExecutionContext> {
        private final String existingOwningType;
        private final String constantName;
        private final String owningType;
        private final String newConstantName;

        public ReplaceConstantWithAnotherConstantVisitor(String existingFullyQualifiedConstantName, String fullyQualifiedConstantName) {
            this.existingOwningType = existingFullyQualifiedConstantName.substring(0, existingFullyQualifiedConstantName.lastIndexOf(46));
            this.constantName = existingFullyQualifiedConstantName.substring(existingFullyQualifiedConstantName.lastIndexOf(46) + 1);
            this.owningType = fullyQualifiedConstantName.substring(0, fullyQualifiedConstantName.lastIndexOf(46));
            this.newConstantName = fullyQualifiedConstantName.substring(fullyQualifiedConstantName.lastIndexOf(46) + 1);
        }

        @Override
        public J visitFieldAccess(J.FieldAccess fieldAccess, ExecutionContext executionContext) {
            JavaType.Variable fieldType = fieldAccess.getName().getFieldType();
            if (this.isConstant(fieldType)) {
                return this.replaceFieldAccess(fieldAccess, fieldType);
            }
            return super.visitFieldAccess(fieldAccess, executionContext);
        }

        @Override
        public J visitIdentifier(J.Identifier ident, ExecutionContext executionContext) {
            JavaType.Variable fieldType = ident.getFieldType();
            if (this.isConstant(fieldType) && !this.isVariableDeclaration()) {
                return this.replaceFieldAccess(ident, fieldType);
            }
            return super.visitIdentifier(ident, executionContext);
        }

        private J replaceFieldAccess(Expression fieldAccess, JavaType.Variable fieldType) {
            JavaTemplate.Builder templateBuilder;
            JavaType owner = fieldType.getOwner();
            while (owner instanceof JavaType.FullyQualified) {
                this.maybeRemoveImport(((JavaType.FullyQualified)owner).getFullyQualifiedName());
                owner = ((JavaType.FullyQualified)owner).getOwningClass();
            }
            if (fieldAccess instanceof J.Identifier) {
                this.maybeAddImport(this.owningType, this.newConstantName, false);
                templateBuilder = JavaTemplate.builder(() -> ((ReplaceConstantWithAnotherConstantVisitor)this).getCursor(), this.newConstantName).staticImports(this.owningType + '.' + this.newConstantName);
            } else {
                this.maybeAddImport(this.owningType, false);
                templateBuilder = JavaTemplate.builder(() -> ((ReplaceConstantWithAnotherConstantVisitor)this).getCursor(), this.owningType.substring(this.owningType.lastIndexOf(46) + 1) + '.' + this.newConstantName).imports(this.owningType);
            }
            return fieldAccess.withTemplate(templateBuilder.build(), fieldAccess.getCoordinates().replace(), new Object[0]).withPrefix(fieldAccess.getPrefix());
        }

        private boolean isConstant(@Nullable JavaType.Variable varType) {
            return varType != null && TypeUtils.isOfClassType(varType.getOwner(), this.existingOwningType) && varType.getName().equals(this.constantName);
        }

        private boolean isVariableDeclaration() {
            Cursor maybeVariable = this.getCursor().dropParentUntil(is -> is instanceof J.VariableDeclarations || is instanceof J.CompilationUnit);
            if (!(maybeVariable.getValue() instanceof J.VariableDeclarations)) {
                return false;
            }
            JavaType.Variable variableType = ((J.VariableDeclarations)maybeVariable.getValue()).getVariables().get(0).getVariableType();
            if (variableType == null) {
                return true;
            }
            JavaType.FullyQualified ownerFqn = TypeUtils.asFullyQualified(variableType.getOwner());
            if (ownerFqn == null) {
                return true;
            }
            return this.constantName.equals(((J.VariableDeclarations)maybeVariable.getValue()).getVariables().get(0).getSimpleName()) && this.existingOwningType.equals(ownerFqn.getFullyQualifiedName());
        }
    }
}

