/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.extend.aspect;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import org.noear.solon.core.wrap.MethodWrap;
import org.noear.solon.extend.aspect.asm.AsmProxy;

public class BeanInvocationHandler
implements InvocationHandler {
    private Object bean;
    private Object proxy;
    private InvocationHandler handler;

    public BeanInvocationHandler(Object bean) {
        this(bean.getClass(), bean);
    }

    public BeanInvocationHandler(Class<?> clazz, Object bean) {
        this(clazz, bean, null);
    }

    public BeanInvocationHandler(Object bean, InvocationHandler handler) {
        this(bean.getClass(), bean, handler);
    }

    public BeanInvocationHandler(Class<?> clazz, Object bean, InvocationHandler handler) {
        try {
            Constructor<?> constructor = clazz.getConstructor(new Class[0]);
            Object[] constructorParam = new Object[]{};
            this.handler = handler;
            this.bean = bean;
            this.proxy = AsmProxy.newProxyInstance(this, clazz, constructor, constructorParam);
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Throwable ex) {
            throw new RuntimeException(ex);
        }
    }

    public Object getProxy() {
        return this.proxy;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (this.handler == null) {
            method.setAccessible(true);
            Object result = MethodWrap.get((Method)method).invokeByAspect(this.bean, args);
            return result;
        }
        return this.handler.invoke(this.bean, method, args);
    }
}

