/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.security.systemgraph;

import java.util.function.Supplier;
import org.neo4j.cypher.internal.security.FormatException;
import org.neo4j.cypher.internal.security.SecureHasher;
import org.neo4j.cypher.internal.security.SystemGraphCredential;
import org.neo4j.dbms.database.DatabaseContext;
import org.neo4j.dbms.database.DatabaseContextProvider;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.security.AuthProviderFailedException;
import org.neo4j.kernel.api.exceptions.InvalidArgumentsException;
import org.neo4j.kernel.database.NamedDatabaseId;
import org.neo4j.kernel.impl.security.Credential;
import org.neo4j.kernel.impl.security.User;

public class SystemGraphRealmHelper {
    private final Supplier<GraphDatabaseService> systemSupplier;
    private final SecureHasher secureHasher;
    private GraphDatabaseService systemDb;
    public static final String IS_SUSPENDED = "is_suspended";
    public static final String DEFAULT_DATABASE = "default_database";

    public SystemGraphRealmHelper(Supplier<GraphDatabaseService> systemSupplier, SecureHasher secureHasher) {
        this.systemSupplier = systemSupplier;
        this.secureHasher = secureHasher;
    }

    public User getUser(String username) throws InvalidArgumentsException, FormatException {
        User user;
        block9: {
            Transaction tx = this.getSystemDb().beginTx();
            try {
                Node userNode = tx.findNode(Label.label((String)"User"), "name", (Object)username);
                if (userNode == null) {
                    throw new InvalidArgumentsException("User '" + username + "' does not exist.");
                }
                SystemGraphCredential credential = SystemGraphCredential.deserialize((String)((String)userNode.getProperty("credentials")), (SecureHasher)this.secureHasher);
                String id = userNode.hasProperty("id") ? (String)userNode.getProperty("id") : null;
                boolean requirePasswordChange = (Boolean)userNode.getProperty("passwordChangeRequired");
                boolean suspended = (Boolean)userNode.getProperty("suspended");
                tx.commit();
                User.Builder builder = new User.Builder(username, (Credential)credential).withId(id).withRequiredPasswordChange(requirePasswordChange);
                builder = suspended ? builder.withFlag(IS_SUSPENDED) : builder.withoutFlag(IS_SUSPENDED);
                user = builder.build();
                if (tx == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (tx != null) {
                        try {
                            tx.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (NotFoundException n) {
                    throw new InvalidArgumentsException("User '" + username + "' does not exist.");
                }
            }
            tx.close();
        }
        return user;
    }

    public GraphDatabaseService getSystemDb() {
        if (this.systemDb == null) {
            this.systemDb = this.systemSupplier.get();
        }
        return this.systemDb;
    }

    public static Supplier<GraphDatabaseService> makeSystemSupplier(DatabaseContextProvider<?> databaseContextProvider) {
        return () -> ((DatabaseContext)databaseContextProvider.getDatabaseContext(NamedDatabaseId.NAMED_SYSTEM_DATABASE_ID).orElseThrow(() -> new AuthProviderFailedException("No database called `system` was found."))).databaseFacade();
    }
}

