/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.procedure.impl;

import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.neo4j.collection.RawIterator;
import org.neo4j.function.ThrowingFunction;
import org.neo4j.internal.kernel.api.exceptions.ProcedureException;
import org.neo4j.internal.kernel.api.procs.ProcedureHandle;
import org.neo4j.internal.kernel.api.procs.ProcedureSignature;
import org.neo4j.internal.kernel.api.procs.QualifiedName;
import org.neo4j.internal.kernel.api.procs.UserAggregationReducer;
import org.neo4j.internal.kernel.api.procs.UserFunctionHandle;
import org.neo4j.internal.kernel.api.procs.UserFunctionSignature;
import org.neo4j.kernel.api.ResourceMonitor;
import org.neo4j.kernel.api.procedure.CallableProcedure;
import org.neo4j.kernel.api.procedure.CallableUserAggregationFunction;
import org.neo4j.kernel.api.procedure.CallableUserFunction;
import org.neo4j.kernel.api.procedure.Context;
import org.neo4j.kernel.api.procedure.ProcedureView;
import org.neo4j.procedure.impl.ComponentRegistry;
import org.neo4j.procedure.impl.ProcedureRegistry;
import org.neo4j.values.AnyValue;

public class ProcedureViewImpl
implements ProcedureView {
    private final ProcedureRegistry registry;
    private final ComponentRegistry safeComponents;
    private final ComponentRegistry allComponents;

    public ProcedureViewImpl(ProcedureRegistry registryView, ComponentRegistry safeComponents, ComponentRegistry allComponents) {
        this.registry = registryView;
        this.safeComponents = safeComponents;
        this.allComponents = allComponents;
    }

    public <T> ThrowingFunction<Context, T, ProcedureException> lookupComponentProvider(Class<T> cls, boolean safe) {
        ComponentRegistry registryView = safe ? this.safeComponents : this.allComponents;
        return registryView.providerFor(cls);
    }

    public ProcedureHandle procedure(QualifiedName name) throws ProcedureException {
        return this.registry.procedure(name);
    }

    public UserFunctionHandle function(QualifiedName name) {
        return this.registry.function(name);
    }

    public UserFunctionHandle aggregationFunction(QualifiedName name) {
        return this.registry.aggregationFunction(name);
    }

    public int[] getIdsOfFunctionsMatching(Predicate<CallableUserFunction> predicate) {
        return this.registry.getIdsOfFunctionsMatching(predicate);
    }

    public int[] getIdsOfAggregatingFunctionsMatching(Predicate<CallableUserAggregationFunction> predicate) {
        return this.registry.getIdsOfAggregatingFunctionsMatching(predicate);
    }

    public Set<ProcedureSignature> getAllProcedures() {
        return this.registry.getAllProcedures();
    }

    public int[] getIdsOfProceduresMatching(Predicate<CallableProcedure> predicate) {
        return this.registry.getIdsOfProceduresMatching(predicate);
    }

    public Stream<UserFunctionSignature> getAllNonAggregatingFunctions() {
        return this.registry.getAllNonAggregatingFunctions();
    }

    public Stream<UserFunctionSignature> getAllAggregatingFunctions() {
        return this.registry.getAllAggregatingFunctions();
    }

    public RawIterator<AnyValue[], ProcedureException> callProcedure(Context ctx, int id, AnyValue[] input, ResourceMonitor resourceMonitor) throws ProcedureException {
        return this.registry.callProcedure(ctx, id, input, resourceMonitor);
    }

    public AnyValue callFunction(Context ctx, int id, AnyValue[] input) throws ProcedureException {
        return this.registry.callFunction(ctx, id, input);
    }

    public UserAggregationReducer createAggregationFunction(Context ctx, int id) throws ProcedureException {
        return this.registry.createAggregationFunction(ctx, id);
    }
}

