/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.index.collector;

import java.io.IOException;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.CollectionTerminatedException;
import org.apache.lucene.search.SimpleCollector;

public final class FirstHitCollector
extends SimpleCollector {
    public static final int NO_MATCH = -1;
    private int result = -1;
    private int readerDocBase;

    public boolean hasMatched() {
        return this.result != -1;
    }

    public int getMatchedDoc() {
        return this.result;
    }

    public void collect(int doc) throws IOException {
        this.result = this.readerDocBase + doc;
        throw new CollectionTerminatedException();
    }

    public boolean needsScores() {
        return false;
    }

    protected void doSetNextReader(LeafReaderContext context) throws IOException {
        super.doSetNextReader(context);
        this.readerDocBase = context.docBase;
    }
}

