/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema.config;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.neo4j.configuration.GroupSetting;
import org.neo4j.configuration.GroupSettingHelper;
import org.neo4j.configuration.SettingBuilder;
import org.neo4j.configuration.SettingConstraints;
import org.neo4j.configuration.SettingValueParser;
import org.neo4j.configuration.SettingValueParsers;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.values.storable.CoordinateReferenceSystem;

public class CrsConfig
implements GroupSetting {
    private static final String PREFIX = "internal.dbms.db.spatial.crs";
    public final Setting<List<Double>> min;
    public final Setting<List<Double>> max;
    public final CoordinateReferenceSystem crs;
    private final String name;

    public static CrsConfig group(CoordinateReferenceSystem crs) {
        return new CrsConfig(crs.getName());
    }

    public CrsConfig() {
        this(null);
    }

    private CrsConfig(String name) {
        this.name = name;
        if (name != null) {
            this.crs = CoordinateReferenceSystem.byName((String)name);
            ArrayList<Double> defaultValue = new ArrayList<Double>(Collections.nCopies(this.crs.getDimension(), Double.NaN));
            this.min = this.getBuilder("min", SettingValueParsers.listOf((SettingValueParser)SettingValueParsers.DOUBLE), defaultValue).internal().addConstraint(SettingConstraints.size((int)this.crs.getDimension())).build();
            this.max = this.getBuilder("max", SettingValueParsers.listOf((SettingValueParser)SettingValueParsers.DOUBLE), defaultValue).internal().addConstraint(SettingConstraints.size((int)this.crs.getDimension())).build();
        } else {
            this.crs = null;
            this.min = null;
            this.max = null;
        }
    }

    public String name() {
        return this.name;
    }

    public String getPrefix() {
        return PREFIX;
    }

    private <T> SettingBuilder<T> getBuilder(String suffix, SettingValueParser<T> parser, T defaultValue) {
        return GroupSettingHelper.getBuilder((String)this.getPrefix(), (String)this.name(), (String)suffix, parser, defaultValue);
    }
}

