/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.coreapi.schema;

import java.util.Map;
import org.neo4j.graphdb.ConstraintViolationException;
import org.neo4j.graphdb.schema.AnyTokens;
import org.neo4j.graphdb.schema.IndexCreator;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.graphdb.schema.IndexSetting;
import org.neo4j.graphdb.schema.IndexSettingUtil;
import org.neo4j.graphdb.schema.IndexType;
import org.neo4j.internal.schema.IndexConfig;
import org.neo4j.kernel.impl.coreapi.schema.InternalSchemaActions;

public class TokenIndexCreator
implements IndexCreator {
    private final InternalSchemaActions actions;
    private final AnyTokens tokens;
    private final String indexName;
    private final IndexConfig indexConfig;

    public TokenIndexCreator(InternalSchemaActions actions, AnyTokens tokens) {
        this(actions, tokens, null, null);
    }

    public TokenIndexCreator(InternalSchemaActions actions, AnyTokens tokens, String indexName, IndexConfig indexConfig) {
        this.actions = actions;
        this.tokens = tokens;
        this.indexName = indexName;
        this.indexConfig = indexConfig;
        actions.assertInOpenTransaction();
    }

    public IndexCreator on(String propertyKey) {
        this.actions.assertInOpenTransaction();
        throw new ConstraintViolationException("LOOKUP indexes doesn't support inclusion of property keys.");
    }

    public IndexCreator withName(String indexName) {
        this.actions.assertInOpenTransaction();
        return new TokenIndexCreator(this.actions, this.tokens, indexName, this.indexConfig);
    }

    public IndexCreator withIndexType(IndexType type) {
        this.actions.assertInOpenTransaction();
        if (type != IndexType.LOOKUP) {
            throw new ConstraintViolationException("Only LOOKUP index type supported for token indexes.");
        }
        return this;
    }

    public IndexCreator withIndexConfiguration(Map<IndexSetting, Object> indexConfiguration) {
        this.actions.assertInOpenTransaction();
        return new TokenIndexCreator(this.actions, this.tokens, this.indexName, IndexSettingUtil.toIndexConfigFromIndexSettingObjectMap(indexConfiguration));
    }

    public IndexDefinition create() throws ConstraintViolationException {
        this.actions.assertInOpenTransaction();
        return this.actions.createIndexDefinition(this.tokens, this.indexName, this.indexConfig);
    }
}

