/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.transaction.monitor;

import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.neo4j.configuration.Config;
import org.neo4j.kernel.api.KernelTransactionHandle;
import org.neo4j.kernel.api.TerminationMark;
import org.neo4j.kernel.api.TransactionTimeout;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.impl.api.KernelTransactions;
import org.neo4j.kernel.impl.api.TransactionVisibilityProvider;
import org.neo4j.kernel.impl.api.transaction.monitor.TransactionMonitor;
import org.neo4j.kernel.impl.api.transaction.trace.TransactionInitializationTrace;
import org.neo4j.logging.internal.LogService;
import org.neo4j.time.SystemNanoClock;

public class KernelTransactionMonitor
extends TransactionMonitor<MonitoredKernelTransaction>
implements TransactionVisibilityProvider {
    private final KernelTransactions kernelTransactions;
    private final AtomicLong oldestVisibilityBoundary = new AtomicLong(1L);
    private final AtomicLong oldestVisibleClosedTransactionId = new AtomicLong(1L);

    public KernelTransactionMonitor(KernelTransactions kernelTransactions, Config config, SystemNanoClock clock, LogService logService) {
        super(config, clock, logService);
        this.kernelTransactions = kernelTransactions;
    }

    @Override
    protected void updateActiveTransactionBoundaries(Set<MonitoredKernelTransaction> activeTransactions) {
        long oldestTxId = Long.MAX_VALUE;
        long oldestHorizon = Long.MAX_VALUE;
        for (MonitoredKernelTransaction monitoredTx : activeTransactions) {
            if (!monitoredTx.terminationMark().isEmpty()) continue;
            oldestTxId = Math.min(oldestTxId, monitoredTx.kernelTransaction.getLastClosedTxId());
            oldestHorizon = Math.min(oldestHorizon, monitoredTx.kernelTransaction.getTransactionHorizon());
        }
        if (oldestTxId != Long.MAX_VALUE) {
            this.oldestVisibleClosedTransactionId.setRelease(oldestTxId);
        }
        if (oldestHorizon != Long.MAX_VALUE) {
            this.oldestVisibilityBoundary.setRelease(oldestHorizon);
        }
    }

    @Override
    protected Set<MonitoredKernelTransaction> getActiveTransactions() {
        return this.kernelTransactions.activeTransactions().stream().map(MonitoredKernelTransaction::new).collect(Collectors.toSet());
    }

    @Override
    public long oldestVisibleClosedTransactionId() {
        return this.oldestVisibleClosedTransactionId.getAcquire();
    }

    @Override
    public long oldestObservableHorizon() {
        return this.oldestVisibilityBoundary.getAcquire();
    }

    @Override
    public long youngestObservableHorizon() {
        long youngestHorizon = Long.MIN_VALUE;
        for (MonitoredKernelTransaction monitoredTx : this.getActiveTransactions()) {
            if (!monitoredTx.terminationMark().isEmpty()) continue;
            youngestHorizon = Math.max(youngestHorizon, monitoredTx.kernelTransaction.getTransactionHorizon());
        }
        return youngestHorizon;
    }

    static class MonitoredKernelTransaction
    implements TransactionMonitor.MonitoredTransaction {
        private final KernelTransactionHandle kernelTransaction;

        private MonitoredKernelTransaction(KernelTransactionHandle kernelTransaction) {
            this.kernelTransaction = kernelTransaction;
        }

        @Override
        public long startTimeNanos() {
            return this.kernelTransaction.startTimeNanos();
        }

        @Override
        public TransactionTimeout timeout() {
            return this.kernelTransaction.timeout();
        }

        @Override
        public Optional<TerminationMark> terminationMark() {
            return this.kernelTransaction.terminationMark();
        }

        @Override
        public boolean isSchemaTransaction() {
            return this.kernelTransaction.isSchemaTransaction();
        }

        @Override
        public boolean markForTermination(Status reason) {
            return this.kernelTransaction.markForTermination(reason);
        }

        @Override
        public String getIdentifyingDescription() {
            return this.kernelTransaction.toString();
        }

        @Override
        public TransactionInitializationTrace transactionInitialisationTrace() {
            return this.kernelTransaction.transactionInitialisationTrace();
        }
    }
}

