/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.traversal;

import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.PathExpander;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.ResourceIterable;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.traversal.BranchState;
import org.neo4j.graphdb.traversal.InitialBranchState;
import org.neo4j.graphdb.traversal.TraversalBranch;
import org.neo4j.graphdb.traversal.TraversalContext;
import org.neo4j.internal.helpers.collection.ResourceClosingIterator;
import org.neo4j.kernel.impl.traversal.TraversalBranchImpl;

public class TraversalBranchWithState
extends TraversalBranchImpl
implements BranchState {
    protected final Object stateForMe;
    protected Object stateForChildren;

    public TraversalBranchWithState(TraversalBranch parent, int depth, Node source, Relationship toHere, Object inheritedState) {
        super(parent, depth, source, toHere);
        this.stateForMe = this.stateForChildren = inheritedState;
    }

    public TraversalBranchWithState(TraversalBranch parent, Node source, InitialBranchState initialState) {
        super(parent, source);
        this.stateForMe = this.stateForChildren = initialState.initialState((Path)this);
    }

    public void setState(Object state) {
        this.stateForChildren = state;
    }

    public Object getState() {
        return this.stateForMe;
    }

    @Override
    protected TraversalBranch newNextBranch(Node node, Relationship relationship) {
        return new TraversalBranchWithState(this, this.length() + 1, node, relationship, this.stateForChildren);
    }

    protected ResourceIterator<Relationship> expandRelationshipsWithoutChecks(PathExpander expander) {
        return ResourceClosingIterator.fromResourceIterable((ResourceIterable)expander.expand((Path)this, (BranchState)this));
    }

    @Override
    public Object state() {
        return this.stateForMe;
    }

    @Override
    protected void evaluate(TraversalContext context) {
        this.setEvaluation(context.evaluate((TraversalBranch)this, (BranchState)this));
    }
}

