/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import org.eclipse.collections.api.iterator.LongIterator;
import org.eclipse.collections.api.set.primitive.LongSet;
import org.neo4j.collection.PrimitiveLongCollections;
import org.neo4j.internal.kernel.api.KernelReadTracer;
import org.neo4j.internal.kernel.api.security.AccessMode;
import org.neo4j.internal.schema.IndexOrder;
import org.neo4j.kernel.api.index.IndexProgressor;
import org.neo4j.kernel.api.txstate.TransactionState;
import org.neo4j.kernel.impl.newapi.CursorPool;
import org.neo4j.kernel.impl.newapi.IndexCursor;
import org.neo4j.kernel.impl.newapi.PrimitiveSortedMergeJoin;
import org.neo4j.kernel.impl.newapi.Read;

abstract class DefaultEntityTokenIndexCursor<SELF extends DefaultEntityTokenIndexCursor<SELF>>
extends IndexCursor<IndexProgressor, SELF>
implements IndexProgressor.EntityTokenClient {
    protected Read read;
    protected long entity = -1L;
    protected long entityFromIndex;
    protected int tokenId;
    private LongIterator added;
    private LongSet removed;
    private boolean useMergeSort;
    private final PrimitiveSortedMergeJoin sortedMergeJoin = new PrimitiveSortedMergeJoin();
    private AccessMode accessMode;
    private boolean shortcutSecurity;

    DefaultEntityTokenIndexCursor(CursorPool<SELF> pool) {
        super(pool);
    }

    public abstract void release();

    protected abstract boolean innerNext();

    protected abstract LongIterator createAddedInTxState(TransactionState var1, int var2, IndexOrder var3);

    protected abstract LongSet createDeletedInTxState(TransactionState var1, int var2);

    protected abstract void traceScan(KernelReadTracer var1, int var2);

    protected abstract void traceNext(KernelReadTracer var1, long var2);

    protected abstract boolean allowedToSeeAllEntitiesWithToken(AccessMode var1, int var2);

    protected abstract boolean allowedToSeeEntity(AccessMode var1, long var2);

    public void initialize(IndexProgressor progressor, int token, IndexOrder order) {
        this.initialize(progressor);
        if (this.read.hasTxStateWithChanges()) {
            this.added = this.createAddedInTxState(this.read.txState(), token, order);
            this.removed = this.createDeletedInTxState(this.read.txState(), token);
            boolean bl = this.useMergeSort = order != IndexOrder.NONE;
            if (this.useMergeSort) {
                this.sortedMergeJoin.initialize(order);
            }
        } else {
            this.useMergeSort = false;
        }
        this.accessMode = this.read.getAccessMode();
        this.tokenId = token;
        this.initSecurity(token);
        if (this.tracer != null) {
            this.traceScan(this.tracer, token);
        }
    }

    public void initialize(IndexProgressor progressor, int token, LongIterator added, LongSet removed, AccessMode accessMode) {
        this.initialize(progressor);
        this.useMergeSort = false;
        this.added = added;
        this.removed = removed;
        this.accessMode = accessMode;
        this.tokenId = token;
        this.initSecurity(token);
        if (this.tracer != null) {
            this.traceScan(this.tracer, token);
        }
    }

    public boolean acceptEntity(long reference, int tokenId) {
        if (this.isRemoved(reference) || !this.allowed(reference)) {
            return false;
        }
        this.entityFromIndex = reference;
        this.tokenId = tokenId;
        return true;
    }

    public boolean next() {
        boolean hasNext;
        this.entity = -1L;
        this.entityFromIndex = -1L;
        boolean bl = hasNext = this.useMergeSort ? this.nextWithOrdering() : this.nextWithoutOrder();
        if (hasNext && this.tracer != null) {
            this.traceNext(this.tracer, this.entity);
        }
        return hasNext;
    }

    @Override
    public void closeInternal() {
        if (!this.isClosed()) {
            this.closeProgressor();
            this.entity = -1L;
            this.entityFromIndex = -1L;
            this.tokenId = -1;
            this.read = null;
            this.added = null;
            this.removed = null;
            this.accessMode = null;
        }
        super.closeInternal();
    }

    public boolean isClosed() {
        return this.isProgressorClosed();
    }

    public void setRead(Read read) {
        this.read = read;
    }

    public long entityReference() {
        return this.entity;
    }

    protected boolean allowed(long reference) {
        return this.shortcutSecurity || this.allowedToSeeEntity(this.accessMode, reference);
    }

    protected long nextEntity() {
        return this.entityFromIndex;
    }

    private void initSecurity(int token) {
        this.shortcutSecurity = this.allowedToSeeAllEntitiesWithToken(this.accessMode, token);
    }

    private boolean nextWithoutOrder() {
        if (this.added != null && this.added.hasNext()) {
            this.entity = this.added.next();
        } else if (this.innerNext()) {
            this.entity = this.nextEntity();
        }
        return this.entity != -1L;
    }

    private boolean nextWithOrdering() {
        long nextId;
        if (this.sortedMergeJoin.needsA() && this.added.hasNext()) {
            this.sortedMergeJoin.setA(this.added.next());
        }
        if (this.sortedMergeJoin.needsB() && this.innerNext()) {
            this.sortedMergeJoin.setB(this.entityFromIndex);
        }
        if ((nextId = this.sortedMergeJoin.next()) == -1L) {
            return false;
        }
        this.entity = nextId;
        return true;
    }

    private boolean isRemoved(long reference) {
        return this.removed != null && this.removed.contains(reference);
    }

    protected static LongIterator sortTxState(LongSet frozenAdded, IndexOrder order) {
        return switch (order) {
            default -> throw new IncompatibleClassChangeError();
            case IndexOrder.NONE -> frozenAdded.longIterator();
            case IndexOrder.ASCENDING, IndexOrder.DESCENDING -> DefaultEntityTokenIndexCursor.sorted(frozenAdded.toSortedArray(), order);
        };
    }

    private static LongIterator sorted(long[] items, IndexOrder order) {
        return IndexOrder.DESCENDING == order ? PrimitiveLongCollections.reverseIterator((long[])items) : PrimitiveLongCollections.iterator((long[])items);
    }
}

