/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import org.neo4j.kernel.impl.index.schema.AbstractArrayType;
import org.neo4j.kernel.impl.index.schema.GenericKey;
import org.neo4j.kernel.impl.index.schema.GeometryArrayType;
import org.neo4j.kernel.impl.index.schema.GeometryType;
import org.neo4j.kernel.impl.index.schema.Type;
import org.neo4j.kernel.impl.index.schema.Types;
import org.neo4j.util.Preconditions;
import org.neo4j.values.storable.CoordinateReferenceSystem;

public class RangeKey
extends GenericKey<RangeKey> {
    @Override
    Type[] getTypesById() {
        return Types.Range.BY_ID;
    }

    @Override
    AbstractArrayType<?>[] getArrayTypes() {
        return Types.Range.BY_ARRAY_TYPE;
    }

    @Override
    Type getLowestByValueGroup() {
        return Types.Range.LOWEST_BY_VALUE_GROUP;
    }

    @Override
    Type getHighestByValueGroup() {
        return Types.Range.HIGHEST_BY_VALUE_GROUP;
    }

    @Override
    Type[] getTypesByGroup() {
        return Types.Range.BY_GROUP;
    }

    @Override
    RangeKey stateSlot(int slot) {
        Preconditions.checkState((slot == 0 ? 1 : 0) != 0, (String)"RangeKey only supports a single key slot");
        return this;
    }

    public void writePoint(CoordinateReferenceSystem crs, double[] coordinate) {
        if (!this.isArray) {
            this.setType(Types.GEOMETRY);
            GeometryType.write(this, crs.getTable().getTableId(), crs.getCode(), coordinate);
        } else {
            if (this.currentArrayOffset != 0 && (this.long0 != (long)crs.getTable().getTableId() || this.long1 != (long)crs.getCode())) {
                throw new IllegalStateException(String.format("Tried to assign a geometry array containing different coordinate reference systems, first:%s, violating:%s at array position:%d", CoordinateReferenceSystem.get((int)((int)this.long0), (int)((int)this.long1)), crs, this.currentArrayOffset));
            }
            GeometryArrayType.write(this, crs.getTable().getTableId(), crs.getCode(), this.currentArrayOffset++, coordinate);
        }
    }
}

