/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.extension;

import java.io.PrintStream;
import org.neo4j.exceptions.UnsatisfiedDependencyException;
import org.neo4j.kernel.extension.ExtensionFactory;
import org.neo4j.kernel.extension.ExtensionFailureStrategy;
import org.neo4j.kernel.extension.FailedToBuildExtensionException;

public class ExtensionFailureStrategies {
    private ExtensionFailureStrategies() {
    }

    private static FailedToBuildExtensionException wrap(ExtensionFactory extensionFactory, UnsatisfiedDependencyException e) {
        return new FailedToBuildExtensionException("Failed to build kernel extension " + extensionFactory + " due to a missing dependency: " + e.getMessage(), e);
    }

    private static FailedToBuildExtensionException wrap(ExtensionFactory extensionFactory, Throwable e) {
        StringBuilder message = new StringBuilder("Failed to build kernel extension ").append(extensionFactory);
        if (e instanceof LinkageError || e instanceof ReflectiveOperationException) {
            if (e instanceof LinkageError) {
                message.append(" because it is compiled with a reference to a class, method, or field, that is not in the class path: ");
            } else {
                message.append(" because it a reflective access to a class, method, or field, that is not in the class path: ");
            }
            message.append('\'').append(e.getMessage()).append('\'');
            message.append(". The most common cause of this problem, is that Neo4j has been upgraded without also upgrading all ");
            message.append("installed extensions, such as APOC. ");
            message.append("Make sure that all of your extensions are build against your specific version of Neo4j.");
        } else {
            message.append(" because of an unanticipated error: '").append(e.getMessage()).append("'.");
        }
        return new FailedToBuildExtensionException(message.toString(), e);
    }

    public static ExtensionFailureStrategy fail() {
        return new ExtensionFailureStrategy(){

            @Override
            public void handle(ExtensionFactory extensionFactory, UnsatisfiedDependencyException e) {
                throw ExtensionFailureStrategies.wrap(extensionFactory, e);
            }

            @Override
            public void handle(ExtensionFactory extensionFactory, Throwable e) {
                throw ExtensionFailureStrategies.wrap(extensionFactory, e);
            }
        };
    }

    public static ExtensionFailureStrategy ignore() {
        return new ExtensionFailureStrategy(){

            @Override
            public void handle(ExtensionFactory extensionFactory, UnsatisfiedDependencyException e) {
            }

            @Override
            public void handle(ExtensionFactory extensionFactory, Throwable e) {
            }
        };
    }

    public static ExtensionFailureStrategy print(final PrintStream out) {
        return new ExtensionFailureStrategy(){

            @Override
            public void handle(ExtensionFactory extensionFactory, UnsatisfiedDependencyException e) {
                ExtensionFailureStrategies.wrap(extensionFactory, e).printStackTrace(out);
            }

            @Override
            public void handle(ExtensionFactory extensionFactory, Throwable e) {
                ExtensionFailureStrategies.wrap(extensionFactory, e).printStackTrace(out);
            }
        };
    }
}

