/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.exceptions.schema;

import org.neo4j.common.EntityType;
import org.neo4j.common.TokenNameLookup;
import org.neo4j.internal.kernel.api.exceptions.schema.ConstraintValidationException;
import org.neo4j.internal.schema.ConstraintDescriptor;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.constraints.TypeConstraintDescriptor;
import org.neo4j.internal.schema.constraints.TypeRepresentation;
import org.neo4j.values.storable.Value;

public class PropertyTypeException
extends ConstraintValidationException {
    private final long entityId;
    private final TypeConstraintDescriptor descriptor;
    private final Value value;
    private final ConstraintValidationException.Phase phase;

    public PropertyTypeException(TypeConstraintDescriptor descriptor, ConstraintValidationException.Phase phase, long entityId, TokenNameLookup tokenNameLookup, Value value) {
        super((ConstraintDescriptor)descriptor, phase, String.format(descriptor.schema().entityType() == EntityType.NODE ? "Node(%s)" : "Relationship(%s)", entityId), tokenNameLookup);
        this.entityId = entityId;
        this.descriptor = descriptor;
        this.value = value;
        this.phase = phase;
    }

    public String getUserMessage(TokenNameLookup tokenNameLookup) {
        SchemaDescriptor schema = this.descriptor.schema();
        EntityType entityType = schema.entityType();
        String entityString = entityType == EntityType.NODE ? "Node" : "Relationship";
        String entityTokenType = entityType == EntityType.NODE ? "label" : "type";
        String entityToken = entityType == EntityType.NODE ? tokenNameLookup.labelGetName(schema.getLabelId()) : tokenNameLookup.relationshipTypeGetName(schema.getRelTypeId());
        String propertyKey = tokenNameLookup.propertyKeyGetName(schema.getPropertyId());
        return switch (this.phase) {
            default -> throw new IncompatibleClassChangeError();
            case ConstraintValidationException.Phase.VERIFICATION -> String.format("%s(%s) property `%s` is of type `%s`.", entityString, this.entityId, propertyKey, TypeRepresentation.infer((Value)this.value).userDescription());
            case ConstraintValidationException.Phase.VALIDATION -> String.format("%s(%s) with %s `%s` required the property `%s` to be of type `%s`, but was of type `%s`.", entityString, this.entityId, entityTokenType, entityToken, propertyKey, this.descriptor.propertyType().userDescription(), TypeRepresentation.infer((Value)this.value).userDescription());
        };
    }
}

