/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.input.csv;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.function.Function;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.Transaction;
import org.neo4j.helpers.Pair;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.kernel.impl.core.Token;
import org.neo4j.kernel.impl.logging.LogService;
import org.neo4j.kernel.impl.logging.NullLogService;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.TokenStore;
import org.neo4j.kernel.impl.transaction.state.NeoStoresSupplier;
import org.neo4j.kernel.impl.util.AutoCreatingHashMap;
import org.neo4j.register.Registers;
import org.neo4j.test.TargetDirectory;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.neo4j.tooling.GlobalGraphOperations;
import org.neo4j.unsafe.impl.batchimport.Configuration;
import org.neo4j.unsafe.impl.batchimport.ParallelBatchImporter;
import org.neo4j.unsafe.impl.batchimport.input.Collector;
import org.neo4j.unsafe.impl.batchimport.input.Collectors;
import org.neo4j.unsafe.impl.batchimport.input.InputEntity;
import org.neo4j.unsafe.impl.batchimport.input.InputNode;
import org.neo4j.unsafe.impl.batchimport.input.InputRelationship;
import org.neo4j.unsafe.impl.batchimport.input.Inputs;
import org.neo4j.unsafe.impl.batchimport.input.csv.Configuration;
import org.neo4j.unsafe.impl.batchimport.input.csv.IdType;
import org.neo4j.unsafe.impl.batchimport.staging.ExecutionMonitors;

public class CsvInputBatchImportIT {
    private static final boolean COMPUTE_DOUBLE_SIDED_RELATIONSHIP_COUNTS = false;
    private final FileSystemAbstraction fs = new DefaultFileSystemAbstraction();
    @Rule
    public final TargetDirectory.TestDirectory directory = TargetDirectory.testDirForTest(this.getClass());
    private final long seed = System.currentTimeMillis();
    private final Random random = new Random(this.seed);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldImportDataComingFromCsvFiles() throws Exception {
        ParallelBatchImporter importer = new ParallelBatchImporter(this.directory.graphDbDir(), (Configuration)this.smallBatchSizeConfig(), (LogService)NullLogService.getInstance(), ExecutionMonitors.invisible());
        List<InputNode> nodeData = this.randomNodeData();
        List<InputRelationship> relationshipData = this.randomRelationshipData(nodeData);
        boolean success = false;
        try {
            importer.doImport(Inputs.csv((File)this.nodeDataAsFile(nodeData), (File)this.relationshipDataAsFile(relationshipData), (IdType)IdType.STRING, (org.neo4j.unsafe.impl.batchimport.input.csv.Configuration)this.lowBufferSize(org.neo4j.unsafe.impl.batchimport.input.csv.Configuration.COMMAS), (Collector)Collectors.silentBadCollector((int)0)));
            this.verifyImportedData(nodeData, relationshipData);
            success = true;
        }
        finally {
            if (!success) {
                System.err.println("Seed " + this.seed);
            }
        }
    }

    private org.neo4j.unsafe.impl.batchimport.input.csv.Configuration lowBufferSize(org.neo4j.unsafe.impl.batchimport.input.csv.Configuration actual) {
        return new Configuration.Overriden(actual){

            public int bufferSize() {
                return 10000;
            }
        };
    }

    private List<InputNode> randomNodeData() {
        ArrayList<InputNode> nodes = new ArrayList<InputNode>();
        for (int i = 0; i < 300; ++i) {
            Object[] properties = new Object[]{"name", "Node " + i};
            String id = UUID.randomUUID().toString();
            nodes.add(new InputNode("source", (long)i, (long)i, (Object)id, properties, null, this.randomLabels(this.random), null));
        }
        return nodes;
    }

    private String[] randomLabels(Random random) {
        String[] labels = new String[random.nextInt(3)];
        for (int i = 0; i < labels.length; ++i) {
            labels[i] = "Label" + random.nextInt(4);
        }
        return labels;
    }

    private Configuration.Default smallBatchSizeConfig() {
        return new Configuration.Default(){

            public int batchSize() {
                return 100;
            }

            public int denseNodeThreshold() {
                return 5;
            }
        };
    }

    private File relationshipDataAsFile(List<InputRelationship> relationshipData) throws IOException {
        File file = this.directory.file("relationships.csv");
        try (Writer writer = this.fs.openAsWriter(file, "utf-8", false);){
            this.println(writer, ":start_id,:end_id,:type");
            for (InputRelationship relationship : relationshipData) {
                this.println(writer, relationship.startNode() + "," + relationship.endNode() + "," + relationship.type());
            }
        }
        return file;
    }

    private File nodeDataAsFile(List<InputNode> nodeData) throws IOException {
        File file = this.directory.file("nodes.csv");
        try (Writer writer = this.fs.openAsWriter(file, "utf-8", false);){
            this.println(writer, "id:ID,name,some-labels:LABEL");
            for (InputNode node : nodeData) {
                String csvLabels = this.csvLabels(node.labels());
                this.println(writer, node.id() + "," + node.properties()[1] + (csvLabels != null && csvLabels.length() > 0 ? "," + csvLabels : ""));
            }
        }
        return file;
    }

    private String csvLabels(String[] labels) {
        if (labels == null || labels.length == 0) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        for (String label : labels) {
            builder.append(builder.length() > 0 ? ";" : "").append(label);
        }
        return builder.toString();
    }

    private void println(Writer writer, String string) throws IOException {
        writer.write(string + "\n");
    }

    private List<InputRelationship> randomRelationshipData(List<InputNode> nodeData) {
        ArrayList<InputRelationship> relationships = new ArrayList<InputRelationship>();
        for (int i = 0; i < 1000; ++i) {
            relationships.add(new InputRelationship("source", (long)i, (long)i, InputEntity.NO_PROPERTIES, null, nodeData.get(this.random.nextInt(nodeData.size())).id(), nodeData.get(this.random.nextInt(nodeData.size())).id(), "TYPE_" + this.random.nextInt(3), null));
        }
        return relationships;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verifyImportedData(List<InputNode> nodeData, List<InputRelationship> relationshipData) {
        HashMap<String, InputNode> expectedNodes = new HashMap<String, InputNode>();
        HashMap<String, String[]> expectedNodeNames = new HashMap<String, String[]>();
        AutoCreatingHashMap<String, Map<String, Map<String, AtomicInteger>>> expectedRelationships = new AutoCreatingHashMap<String, Map<String, Map<String, AtomicInteger>>>(AutoCreatingHashMap.nested(String.class, AutoCreatingHashMap.nested(String.class, AutoCreatingHashMap.values(AtomicInteger.class))));
        AutoCreatingHashMap<String, AtomicLong> expectedNodeCounts = new AutoCreatingHashMap<String, AtomicLong>(AutoCreatingHashMap.values(AtomicLong.class));
        AutoCreatingHashMap<String, Map<String, Map<String, AtomicLong>>> expectedRelationshipCounts = new AutoCreatingHashMap<String, Map<String, Map<String, AtomicLong>>>(AutoCreatingHashMap.nested(String.class, AutoCreatingHashMap.nested(String.class, AutoCreatingHashMap.values(AtomicLong.class))));
        this.buildUpExpectedData(nodeData, relationshipData, expectedNodes, expectedNodeNames, expectedRelationships, expectedNodeCounts, expectedRelationshipCounts);
        GraphDatabaseService db = new TestGraphDatabaseFactory().newEmbeddedDatabase(this.directory.graphDbDir());
        try (Transaction tx = db.beginTx();){
            for (Node node : GlobalGraphOperations.at((GraphDatabaseService)db).getAllNodes()) {
                String name = (String)node.getProperty("name");
                Object[] labels = (String[])expectedNodeNames.remove(name);
                Assert.assertEquals((Object)IteratorUtil.asSet((Object[])labels), this.names(node.getLabels()));
            }
            Assert.assertEquals((long)0L, (long)expectedNodeNames.size());
            for (Relationship relationship : GlobalGraphOperations.at((GraphDatabaseService)db).getAllRelationships()) {
                String startNodeName = (String)relationship.getStartNode().getProperty("name");
                Map inner = (Map)expectedRelationships.get(startNodeName);
                String endNodeName = (String)relationship.getEndNode().getProperty("name");
                Map innerInner = (Map)inner.get(endNodeName);
                String type = relationship.getType().name();
                int countAfterwards = ((AtomicInteger)innerInner.get(type)).decrementAndGet();
                Assert.assertThat((Object)countAfterwards, (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(0)));
                if (countAfterwards != 0) continue;
                innerInner.remove(type);
                if (!innerInner.isEmpty()) continue;
                inner.remove(endNodeName);
                if (!inner.isEmpty()) continue;
                expectedRelationships.remove(startNodeName);
            }
            Assert.assertEquals((long)0L, (long)expectedRelationships.size());
            NeoStores neoStores = (NeoStores)((NeoStoresSupplier)((GraphDatabaseAPI)db).getDependencyResolver().resolveDependency(NeoStoresSupplier.class)).get();
            Function<String, Integer> labelTranslationTable = this.translationTable((TokenStore<?, ?>)neoStores.getLabelTokenStore(), -1);
            for (Pair<Integer, Long> count : this.allNodeCounts(labelTranslationTable, expectedNodeCounts)) {
                Assert.assertEquals((String)("Label count mismatch for label " + count.first()), (long)((Long)count.other()), (long)neoStores.getCounts().nodeCount(((Integer)count.first()).intValue(), Registers.newDoubleLongRegister()).readSecond());
            }
            Function<String, Integer> relationshipTypeTranslationTable = this.translationTable((TokenStore<?, ?>)neoStores.getRelationshipTypeTokenStore(), -1);
            for (Pair<RelationshipCountKey, Long> count : this.allRelationshipCounts(labelTranslationTable, relationshipTypeTranslationTable, expectedRelationshipCounts)) {
                RelationshipCountKey key = (RelationshipCountKey)count.first();
                Assert.assertEquals((String)("Label count mismatch for label " + key), (long)((Long)count.other()), (long)neoStores.getCounts().relationshipCount(key.startLabel, key.type, key.endLabel, Registers.newDoubleLongRegister()).readSecond());
            }
            tx.success();
        }
        finally {
            db.shutdown();
        }
    }

    private Iterable<Pair<RelationshipCountKey, Long>> allRelationshipCounts(Function<String, Integer> labelTranslationTable, Function<String, Integer> relationshipTypeTranslationTable, Map<String, Map<String, Map<String, AtomicLong>>> counts) {
        ArrayList<Pair<RelationshipCountKey, Long>> result = new ArrayList<Pair<RelationshipCountKey, Long>>();
        for (Map.Entry<String, Map<String, Map<String, AtomicLong>>> startLabel : counts.entrySet()) {
            for (Map.Entry<String, Map<String, AtomicLong>> type : startLabel.getValue().entrySet()) {
                for (Map.Entry<String, AtomicLong> endLabel : type.getValue().entrySet()) {
                    RelationshipCountKey key = new RelationshipCountKey((Integer)labelTranslationTable.apply((Object)startLabel.getKey()), (Integer)relationshipTypeTranslationTable.apply((Object)type.getKey()), (Integer)labelTranslationTable.apply((Object)endLabel.getKey()));
                    result.add((Pair<RelationshipCountKey, Long>)Pair.of((Object)key, (Object)endLabel.getValue().longValue()));
                }
            }
        }
        return result;
    }

    private Iterable<Pair<Integer, Long>> allNodeCounts(Function<String, Integer> labelTranslationTable, Map<String, AtomicLong> counts) {
        ArrayList<Pair<Integer, Long>> result = new ArrayList<Pair<Integer, Long>>();
        for (Map.Entry<String, AtomicLong> count : counts.entrySet()) {
            result.add((Pair<Integer, Long>)Pair.of((Object)labelTranslationTable.apply((Object)count.getKey()), (Object)count.getValue().get()));
        }
        counts.put(null, new AtomicLong(counts.size()));
        return result;
    }

    private Function<String, Integer> translationTable(TokenStore<?, ?> tokenStore, final int anyValue) {
        final HashMap<String, Integer> translationTable = new HashMap<String, Integer>();
        for (Token token : tokenStore.getTokens(Integer.MAX_VALUE)) {
            translationTable.put(token.name(), token.id());
        }
        return new Function<String, Integer>(){

            public Integer apply(String from) {
                return from == null ? anyValue : (Integer)translationTable.get(from);
            }
        };
    }

    private Set<String> names(Iterable<Label> labels) {
        HashSet<String> names = new HashSet<String>();
        for (Label label : labels) {
            names.add(label.name());
        }
        return names;
    }

    private void buildUpExpectedData(List<InputNode> nodeData, List<InputRelationship> relationshipData, Map<String, InputNode> expectedNodes, Map<String, String[]> expectedNodeNames, Map<String, Map<String, Map<String, AtomicInteger>>> expectedRelationships, Map<String, AtomicLong> nodeCounts, Map<String, Map<String, Map<String, AtomicLong>>> relationshipCounts) {
        for (InputNode node : nodeData) {
            expectedNodes.put((String)node.id(), node);
            expectedNodeNames.put(this.nameOf(node), node.labels());
            this.countNodeLabels(nodeCounts, node.labels());
        }
        for (InputRelationship relationship : relationshipData) {
            InputNode startNode = expectedNodes.get(relationship.startNode());
            InputNode endNode = expectedNodes.get(relationship.endNode());
            expectedRelationships.get(this.nameOf(startNode)).get(this.nameOf(endNode)).get(relationship.type()).incrementAndGet();
            relationshipCounts.get(null).get(null).get(null).incrementAndGet();
            relationshipCounts.get(null).get(relationship.type()).get(null).incrementAndGet();
            for (String startNodeLabelName : IteratorUtil.asSet((Object[])startNode.labels())) {
                Map<String, Map<String, AtomicLong>> startLabelCounts = relationshipCounts.get(startNodeLabelName);
                startLabelCounts.get(null).get(null).incrementAndGet();
                Map<String, AtomicLong> typeCounts = startLabelCounts.get(relationship.type());
                typeCounts.get(null).incrementAndGet();
            }
            for (String endNodeLabelName : IteratorUtil.asSet((Object[])endNode.labels())) {
                relationshipCounts.get(null).get(null).get(endNodeLabelName).incrementAndGet();
                relationshipCounts.get(null).get(relationship.type()).get(endNodeLabelName).incrementAndGet();
            }
        }
    }

    private void countNodeLabels(Map<String, AtomicLong> nodeCounts, String[] labels) {
        HashSet<String> seen = new HashSet<String>();
        for (String labelName : labels) {
            if (!seen.add(labelName)) continue;
            nodeCounts.get(labelName).incrementAndGet();
        }
    }

    private String nameOf(InputNode node) {
        return (String)node.properties()[1];
    }

    private static class RelationshipCountKey {
        private final int startLabel;
        private final int type;
        private final int endLabel;

        RelationshipCountKey(int startLabel, int type, int endLabel) {
            this.startLabel = startLabel;
            this.type = type;
            this.endLabel = endLabel;
        }

        public String toString() {
            return String.format("[start:%d, type:%d, end:%d]", this.startLabel, this.type, this.endLabel);
        }
    }
}

