/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.input;

import java.util.Iterator;
import org.neo4j.unsafe.impl.batchimport.InputIterable;
import org.neo4j.unsafe.impl.batchimport.InputIterator;
import org.neo4j.unsafe.impl.batchimport.input.SimpleInputIterator;

public class SimpleInputIteratorWrapper<T>
extends SimpleInputIterator<T> {
    private final Iterator<T> source;

    public SimpleInputIteratorWrapper(String sourceDescription, Iterator<T> source) {
        super(sourceDescription);
        this.source = source;
    }

    protected T fetchNextOrNull() {
        return this.source.hasNext() ? (T)this.source.next() : null;
    }

    public static <T> InputIterable<T> wrap(final String sourceDescription, final Iterable<T> source) {
        return new InputIterable<T>(){

            public InputIterator<T> iterator() {
                return new SimpleInputIteratorWrapper(sourceDescription, source.iterator());
            }

            public boolean supportsMultiplePasses() {
                return true;
            }
        };
    }
}

