/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.graphdb.mockfs.EphemeralFileSystemAbstraction;
import org.neo4j.helpers.Service;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.EmbeddedGraphDatabase;
import org.neo4j.kernel.GraphDatabaseDependencies;
import org.neo4j.kernel.extension.KernelExtensionFactory;
import org.neo4j.kernel.impl.factory.CommunityFacadeFactory;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacade;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacadeFactory;
import org.neo4j.kernel.impl.factory.PlatformModule;
import org.neo4j.kernel.impl.logging.LogService;
import org.neo4j.kernel.impl.logging.SimpleLogService;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.test.GraphDatabaseServiceCleaner;

public class ImpermanentGraphDatabase
extends EmbeddedGraphDatabase {
    private static boolean TRACK_UNCLOSED_DATABASE_INSTANCES = false;
    private static final Map<File, Exception> startedButNotYetClosed = new ConcurrentHashMap<File, Exception>();
    protected static final File PATH = new File("target/test-data/impermanent-db");

    @Deprecated
    public ImpermanentGraphDatabase() {
        this(new HashMap<String, String>());
    }

    public ImpermanentGraphDatabase(File storeDir) {
        this(storeDir, new HashMap<String, String>());
    }

    @Deprecated
    public ImpermanentGraphDatabase(Map<String, String> params) {
        this(PATH, params);
    }

    @Deprecated
    public ImpermanentGraphDatabase(File storeDir, Map<String, String> params) {
        this(storeDir, params, Iterables.cast((Iterable)Service.load(KernelExtensionFactory.class)));
    }

    @Deprecated
    public ImpermanentGraphDatabase(Map<String, String> params, Iterable<KernelExtensionFactory<?>> kernelExtensions) {
        this(PATH, params, kernelExtensions);
    }

    @Deprecated
    public ImpermanentGraphDatabase(File storeDir, Map<String, String> params, Iterable<KernelExtensionFactory<?>> kernelExtensions) {
        this(storeDir, params, ImpermanentGraphDatabase.getDependencies(kernelExtensions));
    }

    private static GraphDatabaseFacadeFactory.Dependencies getDependencies(Iterable<KernelExtensionFactory<?>> kernelExtensions) {
        return GraphDatabaseDependencies.newDependencies().kernelExtensions(kernelExtensions);
    }

    public ImpermanentGraphDatabase(File storeDir, Map<String, String> params, GraphDatabaseFacadeFactory.Dependencies dependencies) {
        super(storeDir, params, dependencies);
        this.trackUnclosedUse(storeDir);
    }

    protected void create(File storeDir, Map<String, String> params, GraphDatabaseFacadeFactory.Dependencies dependencies) {
        new CommunityFacadeFactory(){

            protected PlatformModule createPlatform(File storeDir, Map<String, String> params, GraphDatabaseFacadeFactory.Dependencies dependencies, GraphDatabaseFacade graphDatabaseFacade) {
                return new ImpermanentPlatformModule(storeDir, params, dependencies, graphDatabaseFacade);
            }
        }.newFacade(storeDir, new HashMap<String, String>(params), dependencies, (GraphDatabaseFacade)this);
    }

    private void trackUnclosedUse(File storeDir) {
        Exception testThatDidNotCloseDb;
        if (TRACK_UNCLOSED_DATABASE_INSTANCES && (testThatDidNotCloseDb = startedButNotYetClosed.put(storeDir, new Exception("Unclosed database instance"))) != null) {
            testThatDidNotCloseDb.printStackTrace();
        }
    }

    public void shutdown() {
        if (TRACK_UNCLOSED_DATABASE_INSTANCES) {
            startedButNotYetClosed.remove(new File(this.getStoreDir()));
        }
        super.shutdown();
    }

    private static Map<String, String> withForcedInMemoryConfiguration(Map<String, String> params) {
        HashMap<String, String> result = new HashMap<String, String>(params);
        result.put(GraphDatabaseFacadeFactory.Configuration.ephemeral.name(), "true");
        if (!result.containsKey(GraphDatabaseSettings.pagecache_memory.name())) {
            result.put(GraphDatabaseSettings.pagecache_memory.name(), "8M");
        }
        return result;
    }

    public void cleanContent() {
        GraphDatabaseServiceCleaner.cleanDatabaseContent((GraphDatabaseService)this);
    }

    protected static class ImpermanentPlatformModule
    extends PlatformModule {
        public ImpermanentPlatformModule(File storeDir, Map<String, String> params, GraphDatabaseFacadeFactory.Dependencies dependencies, GraphDatabaseFacade graphDatabaseFacade) {
            super(storeDir, ImpermanentGraphDatabase.withForcedInMemoryConfiguration(params), dependencies, graphDatabaseFacade);
        }

        protected FileSystemAbstraction createFileSystemAbstraction() {
            return new EphemeralFileSystemAbstraction();
        }

        protected LogService createLogService(LogProvider userLogProvider) {
            return new SimpleLogService((LogProvider)NullLogProvider.getInstance(), (LogProvider)NullLogProvider.getInstance());
        }
    }
}

