/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.state;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.kernel.api.properties.DefinedProperty;
import org.neo4j.kernel.impl.core.IteratingPropertyReceiver;
import org.neo4j.kernel.impl.store.AbstractRecordStore;
import org.neo4j.kernel.impl.store.InvalidRecordException;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.RelationshipStore;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.PrimitiveRecord;
import org.neo4j.kernel.impl.store.record.PropertyBlock;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.kernel.impl.transaction.state.NeoStoresSupplier;
import org.neo4j.kernel.impl.transaction.state.PropertyLoader;
import org.neo4j.kernel.impl.transaction.state.TransactionRecordState;
import org.neo4j.test.EmbeddedDatabaseRule;

public class PropertyLoaderTest {
    private static final int PROP_KEY_ID = 42;
    @Rule
    public final EmbeddedDatabaseRule db = new EmbeddedDatabaseRule();
    private final IteratingPropertyReceiver receiver = new IteratingPropertyReceiver();
    private final NeoStores neoStores = (NeoStores)Mockito.mock(NeoStores.class);
    private final NodeStore nodeStore = (NodeStore)Mockito.mock(NodeStore.class);
    private final RelationshipStore relationshipStore = (RelationshipStore)Mockito.mock(RelationshipStore.class);
    private final PropertyStore propertyStore = (PropertyStore)Mockito.mock(PropertyStore.class);

    @Before
    public void setUpMocking() throws Exception {
        ((NeoStores)Mockito.doReturn((Object)this.nodeStore).when((Object)this.neoStores)).getNodeStore();
        ((NeoStores)Mockito.doReturn((Object)this.relationshipStore).when((Object)this.neoStores)).getRelationshipStore();
        ((NeoStores)Mockito.doReturn((Object)this.propertyStore).when((Object)this.neoStores)).getPropertyStore();
    }

    @Test
    public void shouldThrowForNotInUseNodeRecord() {
        PropertyLoader loader = new PropertyLoader(this.neoStores());
        try {
            loader.nodeLoadProperties(42L, (TransactionRecordState.PropertyReceiver)this.receiver);
        }
        catch (InvalidRecordException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)Matchers.startsWith((String)"NodeRecord"));
        }
    }

    @Test
    public void shouldThrowForNotInUseRelationshipRecord() {
        PropertyLoader loader = new PropertyLoader(this.neoStores());
        try {
            loader.relLoadProperties(42L, (TransactionRecordState.PropertyReceiver)this.receiver);
        }
        catch (InvalidRecordException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)Matchers.startsWith((String)"RelationshipRecord"));
        }
    }

    @Test
    public void shouldReturnCorrectPropertyChainForNode() {
        this.setUpNode(42L, 1, 2, 3);
        PropertyLoader loader = new PropertyLoader(this.neoStores);
        loader.nodeLoadProperties(42L, (TransactionRecordState.PropertyReceiver)this.receiver);
        Assert.assertEquals(Arrays.asList(DefinedProperty.intProperty((int)42, (int)1), DefinedProperty.intProperty((int)42, (int)2), DefinedProperty.intProperty((int)42, (int)3)), (Object)Iterables.toList((Iterator)this.receiver));
    }

    @Test
    public void shouldReturnCorrectPropertyChainForRelationship() {
        this.setUpRelationship(42L, 1111, 2222);
        PropertyLoader loader = new PropertyLoader(this.neoStores);
        loader.relLoadProperties(42L, (TransactionRecordState.PropertyReceiver)this.receiver);
        Assert.assertEquals(Arrays.asList(DefinedProperty.intProperty((int)42, (int)1111), DefinedProperty.intProperty((int)42, (int)2222)), (Object)Iterables.toList((Iterator)this.receiver));
    }

    private NeoStores neoStores() {
        return (NeoStores)((NeoStoresSupplier)this.db.getGraphDatabaseAPI().getDependencyResolver().resolveDependency(NeoStoresSupplier.class)).get();
    }

    private void setUpNode(long id, int ... propertyValues) {
        this.setUpPropertyChain(id, (Class)NodeRecord.class, (AbstractRecordStore)this.nodeStore, propertyValues);
    }

    private void setUpRelationship(long id, int ... propertyValues) {
        this.setUpPropertyChain(id, (Class)RelationshipRecord.class, (AbstractRecordStore)this.relationshipStore, propertyValues);
    }

    private <R extends PrimitiveRecord> void setUpPropertyChain(long id, Class<R> recordClass, AbstractRecordStore<R> store, int ... propertyValues) {
        PrimitiveRecord record = (PrimitiveRecord)Mockito.mock(recordClass);
        ((PrimitiveRecord)Mockito.doReturn((Object)id).when((Object)record)).getId();
        ((PrimitiveRecord)Mockito.doReturn((Object)1L).when((Object)record)).getNextProp();
        ((AbstractRecordStore)Mockito.doReturn((Object)record).when(store)).getRecord(id);
        ArrayList<PropertyRecord> propertyChain = new ArrayList<PropertyRecord>(propertyValues.length);
        for (int i = 0; i < propertyValues.length; ++i) {
            propertyChain.add(PropertyLoaderTest.newSingleIntProperty(i + 1, propertyValues[i]));
        }
        ((PropertyStore)Mockito.doReturn(propertyChain).when((Object)this.propertyStore)).getPropertyRecordChain(1L);
    }

    private static PropertyRecord newSingleIntProperty(long id, int value) {
        PropertyRecord record = new PropertyRecord(id);
        record.setInUse(true);
        record.addPropertyBlock(PropertyLoaderTest.newSingleIntPropertyBlock(value));
        return record;
    }

    private static PropertyBlock newSingleIntPropertyBlock(int value) {
        PropertyBlock block = new PropertyBlock();
        PropertyStore.encodeValue((PropertyBlock)block, (int)42, (Object)value, null, null);
        block.setKeyIndexId(42);
        return block;
    }
}

