/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicBoolean;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.neo4j.helpers.collection.CloseableVisitor;
import org.neo4j.helpers.collection.Visitor;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.kernel.KernelHealth;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.transaction.DeadSimpleTransactionIdStore;
import org.neo4j.kernel.impl.transaction.TransactionRepresentation;
import org.neo4j.kernel.impl.transaction.command.Command;
import org.neo4j.kernel.impl.transaction.log.BatchingTransactionAppender;
import org.neo4j.kernel.impl.transaction.log.LogFile;
import org.neo4j.kernel.impl.transaction.log.LogFileRecoverer;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.LogVersionRepository;
import org.neo4j.kernel.impl.transaction.log.LogVersionedStoreChannel;
import org.neo4j.kernel.impl.transaction.log.NoSuchTransactionException;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogFile;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogFiles;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogVersionedStoreChannel;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogicalTransactionStore;
import org.neo4j.kernel.impl.transaction.log.PhysicalTransactionRepresentation;
import org.neo4j.kernel.impl.transaction.log.TransactionAppender;
import org.neo4j.kernel.impl.transaction.log.TransactionIdStore;
import org.neo4j.kernel.impl.transaction.log.TransactionMetadataCache;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryReader;
import org.neo4j.kernel.impl.transaction.log.entry.VersionAwareLogEntryReader;
import org.neo4j.kernel.impl.transaction.log.rotation.LogRotation;
import org.neo4j.kernel.impl.transaction.state.RecoverableTransaction;
import org.neo4j.kernel.impl.transaction.tracing.LogAppendEvent;
import org.neo4j.kernel.impl.util.IdOrderingQueue;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.kernel.recovery.Recovery;
import org.neo4j.test.TargetDirectory;

public class PhysicalLogicalTransactionStoreTest {
    private static final KernelHealth kernelHealth = (KernelHealth)Mockito.mock(KernelHealth.class);
    private final FileSystemAbstraction fs = new DefaultFileSystemAbstraction();
    @Rule
    public TargetDirectory.TestDirectory dir = TargetDirectory.testDirForTest(this.getClass());
    private File testDir;

    @Before
    public void setup() {
        this.testDir = this.dir.graphDbDir();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldOpenCleanStore() throws Exception {
        DeadSimpleTransactionIdStore transactionIdStore = new DeadSimpleTransactionIdStore();
        TransactionMetadataCache positionCache = new TransactionMetadataCache(10, 1000);
        LifeSupport life = new LifeSupport();
        PhysicalLogFiles logFiles = new PhysicalLogFiles(this.testDir, "neostore.transaction.db", this.fs);
        PhysicalLogFile.Monitor monitor = (PhysicalLogFile.Monitor)new Monitors().newMonitor(PhysicalLogFile.Monitor.class, new String[0]);
        LogFile logFile = (LogFile)life.add((Lifecycle)new PhysicalLogFile(this.fs, logFiles, 1000L, (TransactionIdStore)transactionIdStore, (LogVersionRepository)Mockito.mock(LogVersionRepository.class), monitor, positionCache));
        life.add((Lifecycle)new BatchingTransactionAppender(logFile, LogRotation.NO_ROTATION, positionCache, (TransactionIdStore)transactionIdStore, IdOrderingQueue.BYPASS, kernelHealth));
        try {
            life.start();
        }
        finally {
            life.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldOpenAndRecoverExistingData() throws Exception {
        DeadSimpleTransactionIdStore transactionIdStore = new DeadSimpleTransactionIdStore();
        TransactionMetadataCache positionCache = new TransactionMetadataCache(10, 100);
        byte[] additionalHeader = new byte[]{1, 2, 5};
        int masterId = 2;
        boolean authorId = true;
        long timeStarted = 12345L;
        long latestCommittedTxWhenStarted = 4545L;
        long timeCommitted = 12355L;
        LifeSupport life = new LifeSupport();
        final PhysicalLogFiles logFiles = new PhysicalLogFiles(this.testDir, "neostore.transaction.db", this.fs);
        PhysicalLogFile.Monitor monitor = (PhysicalLogFile.Monitor)new Monitors().newMonitor(PhysicalLogFile.Monitor.class, new String[0]);
        LogFile logFile = (LogFile)life.add((Lifecycle)new PhysicalLogFile(this.fs, logFiles, 1000L, (TransactionIdStore)transactionIdStore, (LogVersionRepository)Mockito.mock(LogVersionRepository.class), monitor, positionCache));
        life.start();
        try {
            this.addATransactionAndRewind(life, logFile, positionCache, transactionIdStore, additionalHeader, 2, 1, 12345L, 4545L, 12355L);
        }
        finally {
            life.shutdown();
        }
        life = new LifeSupport();
        final AtomicBoolean recoveryRequiredCalled = new AtomicBoolean();
        FakeRecoveryVisitor visitor = new FakeRecoveryVisitor(additionalHeader, 2, 1, 12345L, 12355L, 4545L);
        final LogFileRecoverer recoverer = new LogFileRecoverer((LogEntryReader)new VersionAwareLogEntryReader(), (CloseableVisitor)visitor);
        logFile = (LogFile)life.add((Lifecycle)new PhysicalLogFile(this.fs, logFiles, 1000L, (TransactionIdStore)transactionIdStore, (LogVersionRepository)Mockito.mock(LogVersionRepository.class), monitor, positionCache));
        life.add((Lifecycle)new BatchingTransactionAppender(logFile, LogRotation.NO_ROTATION, positionCache, (TransactionIdStore)transactionIdStore, IdOrderingQueue.BYPASS, kernelHealth));
        life.add((Lifecycle)new Recovery(new Recovery.SPI(){

            public void forceEverything() {
            }

            public Visitor<LogVersionedStoreChannel, IOException> getRecoverer() {
                return recoverer;
            }

            public Iterator<LogVersionedStoreChannel> getLogFiles(final long recoveryVersion) throws IOException {
                return new Iterator<LogVersionedStoreChannel>(){
                    private final StoreChannel channel;
                    private boolean consumed;
                    {
                        this.channel = PhysicalLogFile.openForVersion((PhysicalLogFiles)logFiles, (FileSystemAbstraction)PhysicalLogicalTransactionStoreTest.this.fs, (long)recoveryVersion);
                        this.consumed = false;
                    }

                    @Override
                    public boolean hasNext() {
                        return !this.consumed;
                    }

                    @Override
                    public LogVersionedStoreChannel next() {
                        PhysicalLogVersionedStoreChannel physicalLogVersionedStoreChannel;
                        try {
                            physicalLogVersionedStoreChannel = new PhysicalLogVersionedStoreChannel(this.channel, recoveryVersion, 6);
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                        this.consumed = true;
                        return physicalLogVersionedStoreChannel;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }

            public LogPosition getPositionToRecoverFrom() throws IOException {
                return LogPosition.start((long)0L);
            }

            public void recoveryRequired() {
                recoveryRequiredCalled.set(true);
            }
        }, (Recovery.Monitor)Mockito.mock(Recovery.Monitor.class)));
        try {
            life.start();
        }
        finally {
            life.shutdown();
        }
        Assert.assertEquals((long)1L, (long)visitor.getVisitedTransactions());
        Assert.assertTrue((boolean)recoveryRequiredCalled.get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldExtractMetadataFromExistingTransaction() throws Exception {
        DeadSimpleTransactionIdStore transactionIdStore = new DeadSimpleTransactionIdStore();
        TransactionMetadataCache positionCache = new TransactionMetadataCache(10, 100);
        byte[] additionalHeader = new byte[]{1, 2, 5};
        int masterId = 2;
        boolean authorId = true;
        long timeStarted = 12345L;
        long latestCommittedTxWhenStarted = 4545L;
        long timeCommitted = 12355L;
        LifeSupport life = new LifeSupport();
        PhysicalLogFiles logFiles = new PhysicalLogFiles(this.testDir, "neostore.transaction.db", this.fs);
        PhysicalLogFile.Monitor monitor = (PhysicalLogFile.Monitor)new Monitors().newMonitor(PhysicalLogFile.Monitor.class, new String[0]);
        LogFile logFile = (LogFile)life.add((Lifecycle)new PhysicalLogFile(this.fs, logFiles, 1000L, (TransactionIdStore)transactionIdStore, (LogVersionRepository)Mockito.mock(LogVersionRepository.class), monitor, positionCache));
        life.start();
        try {
            this.addATransactionAndRewind(life, logFile, positionCache, transactionIdStore, additionalHeader, 2, 1, 12345L, 4545L, 12355L);
        }
        finally {
            life.shutdown();
        }
        life = new LifeSupport();
        FakeRecoveryVisitor visitor = new FakeRecoveryVisitor(additionalHeader, 2, 1, 12345L, 12355L, 4545L);
        LogFileRecoverer recoverer = new LogFileRecoverer((LogEntryReader)new VersionAwareLogEntryReader(), (CloseableVisitor)visitor);
        logFile = (LogFile)life.add((Lifecycle)new PhysicalLogFile(this.fs, logFiles, 1000L, (TransactionIdStore)transactionIdStore, (LogVersionRepository)Mockito.mock(LogVersionRepository.class), monitor, positionCache));
        PhysicalLogicalTransactionStore store = new PhysicalLogicalTransactionStore(logFile, positionCache);
        life.start();
        try {
            recoverer.visit((LogVersionedStoreChannel)PhysicalLogFile.openForVersion((PhysicalLogFiles)logFiles, (FileSystemAbstraction)this.fs, (long)0L));
            positionCache.clear();
            Assert.assertThat((Object)store.getMetadataFor(transactionIdStore.getLastCommittedTransactionId()).toString(), (Matcher)CoreMatchers.equalTo((Object)String.format("TransactionMetadata[masterId=%d, authorId=%d, startPosition=%s, checksum=%d]", 2, 1, visitor.getStartPosition(), visitor.getChecksum())));
        }
        finally {
            life.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldThrowNoSuchTransactionExceptionIfMetadataNotFound() throws Exception {
        LogFile logFile = (LogFile)Mockito.mock(LogFile.class);
        TransactionMetadataCache cache = new TransactionMetadataCache(10, 10);
        LifeSupport life = new LifeSupport();
        PhysicalLogicalTransactionStore txStore = new PhysicalLogicalTransactionStore(logFile, cache);
        try {
            life.start();
            try {
                txStore.getMetadataFor(10L);
                Assert.fail((String)"Should have thrown");
            }
            catch (NoSuchTransactionException noSuchTransactionException) {
                // empty catch block
            }
        }
        finally {
            life.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldThrowNoSuchTransactionExceptionIfLogFileIsMissing() throws Exception {
        LogFile logFile = (LogFile)Mockito.mock(LogFile.class);
        Mockito.when((Object)logFile.getReader((LogPosition)Matchers.any(LogPosition.class))).thenThrow(new Throwable[]{new FileNotFoundException()});
        TransactionMetadataCache cache = new TransactionMetadataCache(10, 10);
        cache.cacheTransactionMetadata(10L, new LogPosition(2L, 130L), 1, 1, 100L);
        LifeSupport life = new LifeSupport();
        PhysicalLogicalTransactionStore txStore = new PhysicalLogicalTransactionStore(logFile, cache);
        try {
            life.start();
            try {
                txStore.getTransactions(10L);
                Assert.fail();
            }
            catch (NoSuchTransactionException noSuchTransactionException) {
                // empty catch block
            }
        }
        finally {
            life.shutdown();
        }
    }

    private void addATransactionAndRewind(LifeSupport life, LogFile logFile, TransactionMetadataCache positionCache, TransactionIdStore transactionIdStore, byte[] additionalHeader, int masterId, int authorId, long timeStarted, long latestCommittedTxWhenStarted, long timeCommitted) throws IOException {
        TransactionAppender appender = (TransactionAppender)life.add((Lifecycle)new BatchingTransactionAppender(logFile, LogRotation.NO_ROTATION, positionCache, transactionIdStore, IdOrderingQueue.BYPASS, kernelHealth));
        PhysicalTransactionRepresentation transaction = new PhysicalTransactionRepresentation(this.singleCreateNodeCommand());
        transaction.setHeader(additionalHeader, masterId, authorId, timeStarted, latestCommittedTxWhenStarted, timeCommitted, -1);
        appender.append((TransactionRepresentation)transaction, LogAppendEvent.NULL);
    }

    private Collection<Command> singleCreateNodeCommand() {
        ArrayList<Command> commands = new ArrayList<Command>();
        Command.NodeCommand command = new Command.NodeCommand();
        long id = 0L;
        NodeRecord before = new NodeRecord(id);
        NodeRecord after = new NodeRecord(id);
        after.setInUse(true);
        command.init(before, after);
        commands.add((Command)command);
        return commands;
    }

    private static class FakeRecoveryVisitor
    implements CloseableVisitor<RecoverableTransaction, IOException> {
        private final byte[] additionalHeader;
        private final int masterId;
        private final int authorId;
        private final long timeStarted;
        private final long timeCommitted;
        private final long latestCommittedTxWhenStarted;
        private int visitedTransactions;
        private long checksum;
        private LogPosition startPosition;

        public FakeRecoveryVisitor(byte[] additionalHeader, int masterId, int authorId, long timeStarted, long timeCommitted, long latestCommittedTxWhenStarted) {
            this.additionalHeader = additionalHeader;
            this.masterId = masterId;
            this.authorId = authorId;
            this.timeStarted = timeStarted;
            this.timeCommitted = timeCommitted;
            this.latestCommittedTxWhenStarted = latestCommittedTxWhenStarted;
        }

        public boolean visit(RecoverableTransaction committedTx) throws IOException {
            TransactionRepresentation transaction = committedTx.representation().getTransactionRepresentation();
            Assert.assertArrayEquals((byte[])this.additionalHeader, (byte[])transaction.additionalHeader());
            Assert.assertEquals((long)this.masterId, (long)transaction.getMasterId());
            Assert.assertEquals((long)this.authorId, (long)transaction.getAuthorId());
            Assert.assertEquals((long)this.timeStarted, (long)transaction.getTimeStarted());
            Assert.assertEquals((long)this.timeCommitted, (long)transaction.getTimeCommitted());
            Assert.assertEquals((long)this.latestCommittedTxWhenStarted, (long)transaction.getLatestCommittedTxWhenStarted());
            ++this.visitedTransactions;
            this.checksum = committedTx.representation().getStartEntry().checksum();
            this.startPosition = committedTx.representation().getStartEntry().getStartPosition();
            return false;
        }

        public void close() throws IOException {
        }

        public int getVisitedTransactions() {
            return this.visitedTransactions;
        }

        public long getChecksum() {
            return this.checksum;
        }

        public LogPosition getStartPosition() {
            return this.startPosition;
        }
    }
}

