/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction;

import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.graphdb.event.ErrorState;
import org.neo4j.kernel.KernelHealth;
import org.neo4j.kernel.impl.core.KernelPanicEventGenerator;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.logging.NullLogProvider;

public class KernelHealthTest {
    @Test
    public void shouldGenerateKernelPanicEvents() throws Exception {
        KernelPanicEventGenerator generator = (KernelPanicEventGenerator)Mockito.mock(KernelPanicEventGenerator.class);
        KernelHealth kernelHealth = new KernelHealth(generator, NullLogProvider.getInstance().getLog(KernelHealth.class));
        kernelHealth.healed();
        Exception cause = new Exception("My own fault");
        kernelHealth.panic((Throwable)cause);
        kernelHealth.panic((Throwable)cause);
        ((KernelPanicEventGenerator)Mockito.verify((Object)generator, (VerificationMode)Mockito.times((int)1))).generateEvent(ErrorState.TX_MANAGER_NOT_OK, (Throwable)cause);
    }

    @Test
    public void shouldLogKernelPanicEvent() throws Exception {
        AssertableLogProvider logProvider = new AssertableLogProvider();
        KernelHealth kernelHealth = new KernelHealth((KernelPanicEventGenerator)Mockito.mock(KernelPanicEventGenerator.class), logProvider.getLog(KernelHealth.class));
        kernelHealth.healed();
        String message = "Listen everybody... panic!";
        Exception exception = new Exception(message);
        kernelHealth.panic((Throwable)exception);
        logProvider.assertAtLeastOnce(new AssertableLogProvider.LogMatcher[]{AssertableLogProvider.inLog(KernelHealth.class).error(Is.is((Object)"setting TM not OK. Kernel has encountered some problem, please perform necessary action (tx recovery/restart)"), Matchers.sameInstance((Object)exception))});
    }
}

