/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration.legacystore.v19;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.storemigration.MigrationTestUtils;
import org.neo4j.kernel.impl.storemigration.legacystore.v19.Legacy19PropertyStoreReader;
import org.neo4j.test.TargetDirectory;

public class Legacy19RelationshipStoreReaderTest {
    @Rule
    public TargetDirectory.TestDirectory dir = TargetDirectory.testDirForTest(this.getClass());
    private final FileSystemAbstraction fs = new DefaultFileSystemAbstraction();

    @Test
    public void shouldReadNodeRecords() throws IOException {
        File storeDir = this.dir.graphDbDir();
        MigrationTestUtils.find19FormatHugeStoreDirectory(storeDir);
        Legacy19PropertyStoreReader propStoreReader = new Legacy19PropertyStoreReader(this.fs, new File(storeDir, "neostore.propertystore.db"));
        int propCount = 0;
        Iterator iterator = propStoreReader.readPropertyStore();
        while (iterator.hasNext()) {
            PropertyRecord record = (PropertyRecord)iterator.next();
            if (!record.inUse()) continue;
            ++propCount;
        }
        Assert.assertEquals((long)6000L, (long)propCount);
        propStoreReader.close();
    }
}

