/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration.legacystore.v19;

import java.io.File;
import java.io.IOException;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.storemigration.MigrationTestUtils;
import org.neo4j.kernel.impl.storemigration.legacystore.v19.Legacy19NodeStoreReader;
import org.neo4j.test.TargetDirectory;

public class Legacy19NodeStoreReaderTest {
    @Rule
    public TargetDirectory.TestDirectory dir = TargetDirectory.testDirForTest(this.getClass());
    private final FileSystemAbstraction fs = new DefaultFileSystemAbstraction();

    @Test
    public void shouldReadNodeRecords() throws IOException {
        File storeDir = this.dir.graphDbDir();
        MigrationTestUtils.find19FormatHugeStoreDirectory(storeDir);
        Legacy19NodeStoreReader nodeStoreReader = new Legacy19NodeStoreReader(this.fs, new File(storeDir, "neostore.nodestore.db"));
        Assert.assertEquals((long)1001L, (long)nodeStoreReader.getMaxId());
        int nodeCount = 0;
        for (NodeRecord record : nodeStoreReader) {
            if (!record.inUse()) continue;
            ++nodeCount;
        }
        Assert.assertEquals((long)1000L, (long)nodeCount);
        nodeStoreReader.close();
    }
}

