/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Mockito;
import org.neo4j.function.Function;
import org.neo4j.function.Functions;
import org.neo4j.function.Predicates;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.graphdb.DynamicLabel;
import org.neo4j.graphdb.Transaction;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.kernel.api.ReadOperations;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.TokenNameLookup;
import org.neo4j.kernel.api.exceptions.schema.DuplicateEntitySchemaRuleException;
import org.neo4j.kernel.api.exceptions.schema.DuplicateSchemaRuleException;
import org.neo4j.kernel.api.exceptions.schema.EntitySchemaRuleNotFoundException;
import org.neo4j.kernel.api.exceptions.schema.SchemaRuleNotFoundException;
import org.neo4j.kernel.impl.api.index.inmemory.InMemoryIndexProviderFactory;
import org.neo4j.kernel.impl.core.ThreadToStatementContextBridge;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.SchemaStorage;
import org.neo4j.kernel.impl.store.record.IndexRule;
import org.neo4j.kernel.impl.store.record.NodePropertyConstraintRule;
import org.neo4j.kernel.impl.store.record.RelationshipPropertyExistenceConstraintRule;
import org.neo4j.kernel.impl.store.record.SchemaRule;
import org.neo4j.kernel.impl.store.record.UniquePropertyConstraintRule;
import org.neo4j.test.EmbeddedDatabaseRule;
import org.neo4j.test.KernelExceptionUserMessageMatcher;

public class SchemaStorageTest {
    private static final String LABEL1 = "Label1";
    private static final String LABEL2 = "Label2";
    private static final String TYPE1 = "Type1";
    private static final String PROP1 = "prop1";
    private static final String PROP2 = "prop2";
    @Rule
    public final EmbeddedDatabaseRule db = new EmbeddedDatabaseRule();
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    private SchemaStorage storage;

    @Before
    public void initStorage() throws Exception {
        this.storage = new SchemaStorage((RecordStore)((NeoStores)this.dependencyResolver().resolveDependency(NeoStores.class)).getSchemaStore());
    }

    @Test
    public void shouldReturnIndexRuleForLabelAndProperty() {
        this.createIndex(LABEL1, PROP1);
        this.createIndex(LABEL1, PROP2);
        this.createIndex(LABEL2, PROP1);
        IndexRule rule = this.storage.indexRule(this.labelId(LABEL1), this.propId(PROP1));
        Assert.assertNotNull((Object)rule);
        Assert.assertEquals((long)this.labelId(LABEL1), (long)rule.getLabel());
        Assert.assertEquals((long)this.propId(PROP1), (long)rule.getPropertyKey());
        Assert.assertEquals((Object)SchemaRule.Kind.INDEX_RULE, (Object)rule.getKind());
    }

    @Test
    public void shouldReturnNullIfIndexRuleForLabelAndPropertyDoesNotExist() {
        this.createIndex(LABEL1, PROP1);
        IndexRule rule = this.storage.indexRule(this.labelId(LABEL1), this.propId(PROP2));
        Assert.assertNull((Object)rule);
    }

    @Test
    public void shouldListIndexRulesForLabelPropertyAndKind() {
        this.createUniquenessConstraint(LABEL1, PROP1);
        this.createIndex(LABEL1, PROP2);
        IndexRule rule = this.storage.indexRule(this.labelId(LABEL1), this.propId(PROP1), SchemaStorage.IndexRuleKind.CONSTRAINT);
        Assert.assertNotNull((Object)rule);
        Assert.assertEquals((long)this.labelId(LABEL1), (long)rule.getLabel());
        Assert.assertEquals((long)this.propId(PROP1), (long)rule.getPropertyKey());
        Assert.assertEquals((Object)SchemaRule.Kind.CONSTRAINT_INDEX_RULE, (Object)rule.getKind());
    }

    @Test
    public void shouldListAllIndexRules() {
        this.createIndex(LABEL1, PROP1);
        this.createIndex(LABEL1, PROP2);
        this.createUniquenessConstraint(LABEL2, PROP1);
        Set listedRules = IteratorUtil.asSet((Iterator)this.storage.allIndexRules());
        HashSet<IndexRule> expectedRules = new HashSet<IndexRule>();
        expectedRules.add(new IndexRule(0L, this.labelId(LABEL1), this.propId(PROP1), InMemoryIndexProviderFactory.PROVIDER_DESCRIPTOR, null));
        expectedRules.add(new IndexRule(1L, this.labelId(LABEL1), this.propId(PROP2), InMemoryIndexProviderFactory.PROVIDER_DESCRIPTOR, null));
        expectedRules.add(new IndexRule(2L, this.labelId(LABEL2), this.propId(PROP1), InMemoryIndexProviderFactory.PROVIDER_DESCRIPTOR, Long.valueOf(0L)));
        Assert.assertEquals(expectedRules, (Object)listedRules);
    }

    @Test
    public void shouldListAllSchemaRulesForNodes() {
        this.createIndex(LABEL2, PROP1);
        this.createUniquenessConstraint(LABEL1, PROP1);
        Set listedRules = IteratorUtil.asSet((Iterator)this.storage.schemaRulesForNodes((Function)Functions.identity(), NodePropertyConstraintRule.class, this.labelId(LABEL1), Predicates.alwaysTrue()));
        HashSet<UniquePropertyConstraintRule> expectedRules = new HashSet<UniquePropertyConstraintRule>();
        expectedRules.add(UniquePropertyConstraintRule.uniquenessConstraintRule((long)1L, (int)this.labelId(LABEL1), (int)this.propId(PROP1), (long)0L));
        Assert.assertEquals(expectedRules, (Object)listedRules);
    }

    @Test
    public void shouldListSchemaRulesByClass() {
        this.createIndex(LABEL1, PROP1);
        this.createUniquenessConstraint(LABEL2, PROP1);
        Set listedRules = IteratorUtil.asSet((Iterator)this.storage.schemaRules(UniquePropertyConstraintRule.class));
        HashSet<UniquePropertyConstraintRule> expectedRules = new HashSet<UniquePropertyConstraintRule>();
        expectedRules.add(UniquePropertyConstraintRule.uniquenessConstraintRule((long)0L, (int)this.labelId(LABEL2), (int)this.propId(PROP1), (long)0L));
        Assert.assertEquals(expectedRules, (Object)listedRules);
    }

    @Test
    public void shouldReturnCorrectUniquenessRuleForLabelAndProperty() throws SchemaRuleNotFoundException, DuplicateSchemaRuleException {
        this.createUniquenessConstraint(LABEL1, PROP1);
        this.createUniquenessConstraint(LABEL2, PROP1);
        UniquePropertyConstraintRule rule = this.storage.uniquenessConstraint(this.labelId(LABEL1), this.propId(PROP1));
        Assert.assertNotNull((Object)rule);
        Assert.assertEquals((long)this.labelId(LABEL1), (long)rule.getLabel());
        Assert.assertEquals((long)this.propId(PROP1), (long)rule.getPropertyKey());
        Assert.assertEquals((Object)SchemaRule.Kind.UNIQUENESS_CONSTRAINT, (Object)rule.getKind());
    }

    @Test
    public void shouldThrowExceptionOnNodeRuleNotFound() throws DuplicateSchemaRuleException, SchemaRuleNotFoundException {
        TokenNameLookup tokenNameLookup = this.getDefaultTokenNameLookup();
        this.expectedException.expect(EntitySchemaRuleNotFoundException.class);
        this.expectedException.expect(new KernelExceptionUserMessageMatcher(tokenNameLookup, "Constraint for label 'Label1' and property 'prop1' not found."));
        this.storage.nodePropertyExistenceConstraint(this.labelId(LABEL1), this.propId(PROP1));
    }

    @Test
    public void shouldThrowExceptionOnNodeDuplicateRuleFound() throws DuplicateSchemaRuleException, SchemaRuleNotFoundException {
        TokenNameLookup tokenNameLookup = this.getDefaultTokenNameLookup();
        SchemaStorage schemaStorageSpy = (SchemaStorage)Mockito.spy((Object)this.storage);
        Mockito.when((Object)schemaStorageSpy.loadAllSchemaRules()).thenReturn((Object)IteratorUtil.iterator((Object[])new SchemaRule[]{this.getUniquePropertyConstraintRule(1L, LABEL1, PROP1), this.getUniquePropertyConstraintRule(2L, LABEL1, PROP1)}));
        this.expectedException.expect(DuplicateEntitySchemaRuleException.class);
        this.expectedException.expect(new KernelExceptionUserMessageMatcher(tokenNameLookup, "Multiple constraints found for label 'Label1' and property 'prop1'."));
        schemaStorageSpy.uniquenessConstraint(this.labelId(LABEL1), this.propId(PROP1));
    }

    @Test
    public void shouldThrowExceptionOnRelationshipRuleNotFound() throws DuplicateSchemaRuleException, SchemaRuleNotFoundException {
        TokenNameLookup tokenNameLookup = this.getDefaultTokenNameLookup();
        this.expectedException.expect(EntitySchemaRuleNotFoundException.class);
        this.expectedException.expect(new KernelExceptionUserMessageMatcher(tokenNameLookup, "Constraint for relationship type 'Type1' and property 'prop1' not found."));
        this.storage.relationshipPropertyExistenceConstraint(this.typeId(TYPE1), this.propId(PROP1));
    }

    @Test
    public void shouldThrowExceptionOnRelationshipDuplicateRuleFound() throws DuplicateSchemaRuleException, SchemaRuleNotFoundException {
        TokenNameLookup tokenNameLookup = this.getDefaultTokenNameLookup();
        SchemaStorage schemaStorageSpy = (SchemaStorage)Mockito.spy((Object)this.storage);
        Mockito.when((Object)schemaStorageSpy.loadAllSchemaRules()).thenReturn((Object)IteratorUtil.iterator((Object[])new SchemaRule[]{this.getRelationshipPropertyExistenceConstraintRule(1L, TYPE1, PROP1), this.getRelationshipPropertyExistenceConstraintRule(2L, TYPE1, PROP1)}));
        this.expectedException.expect(DuplicateEntitySchemaRuleException.class);
        this.expectedException.expect(new KernelExceptionUserMessageMatcher(tokenNameLookup, "Multiple constraints found for relationship type 'Type1' and property 'prop1'."));
        schemaStorageSpy.relationshipPropertyExistenceConstraint(this.typeId(TYPE1), this.propId(PROP1));
    }

    private TokenNameLookup getDefaultTokenNameLookup() {
        TokenNameLookup tokenNameLookup = (TokenNameLookup)Mockito.mock(TokenNameLookup.class);
        Mockito.when((Object)tokenNameLookup.labelGetName(this.labelId(LABEL1))).thenReturn((Object)LABEL1);
        Mockito.when((Object)tokenNameLookup.propertyKeyGetName(this.propId(PROP1))).thenReturn((Object)PROP1);
        Mockito.when((Object)tokenNameLookup.relationshipTypeGetName(this.typeId(TYPE1))).thenReturn((Object)TYPE1);
        return tokenNameLookup;
    }

    private UniquePropertyConstraintRule getUniquePropertyConstraintRule(long id, String label, String property) {
        return UniquePropertyConstraintRule.uniquenessConstraintRule((long)id, (int)this.labelId(label), (int)this.propId(property), (long)0L);
    }

    private RelationshipPropertyExistenceConstraintRule getRelationshipPropertyExistenceConstraintRule(long id, String type, String property) {
        return RelationshipPropertyExistenceConstraintRule.relPropertyExistenceConstraintRule((long)id, (int)this.typeId(type), (int)this.propId(property));
    }

    private void createIndex(String labelName, String propertyName) {
        try (Transaction tx = this.db.beginTx();){
            this.db.schema().indexFor(DynamicLabel.label((String)labelName)).on(propertyName).create();
            tx.success();
        }
        this.awaitIndexes();
    }

    private void createUniquenessConstraint(String labelName, String propertyName) {
        try (Transaction tx = this.db.beginTx();){
            this.db.schema().constraintFor(DynamicLabel.label((String)labelName)).assertPropertyIsUnique(propertyName).create();
            tx.success();
        }
        this.awaitIndexes();
    }

    private void awaitIndexes() {
        try (Transaction tx = this.db.beginTx();){
            this.db.schema().awaitIndexesOnline(10L, TimeUnit.SECONDS);
            tx.success();
        }
    }

    private int labelId(String labelName) {
        try (Transaction ignore = this.db.beginTx();){
            int n = this.readOps().labelGetForName(labelName);
            return n;
        }
    }

    private int propId(String propName) {
        try (Transaction ignore = this.db.beginTx();){
            int n = this.readOps().propertyKeyGetForName(propName);
            return n;
        }
    }

    private int typeId(String typeName) {
        try (Transaction ignore = this.db.beginTx();){
            int n = this.readOps().relationshipTypeGetForName(typeName);
            return n;
        }
    }

    private ReadOperations readOps() {
        DependencyResolver dependencyResolver = this.dependencyResolver();
        Statement statement = ((ThreadToStatementContextBridge)dependencyResolver.resolveDependency(ThreadToStatementContextBridge.class)).get();
        return statement.readOperations();
    }

    private DependencyResolver dependencyResolver() {
        return this.db.getGraphDatabaseAPI().getDependencyResolver();
    }
}

