/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.kernel.impl.store.HighestTransactionId;
import org.neo4j.kernel.impl.store.TransactionId;
import org.neo4j.test.Race;

public class HighestTransactionIdTest {
    @Test
    public void shouldHardSetHighest() throws Exception {
        HighestTransactionId highest = new HighestTransactionId(10L, 10L);
        highest.set(8L, 1299128L);
        Assert.assertEquals((Object)new TransactionId(8L, 1299128L), (Object)highest.get());
    }

    @Test
    public void shouldOnlyKeepTheHighestOffered() throws Exception {
        HighestTransactionId highest = new HighestTransactionId(-1L, -1L);
        this.assertAccepted(highest, 2L, 123L);
        this.assertAccepted(highest, 5L, 1231L);
        this.assertRejected(highest, 3L, 334343L);
        this.assertRejected(highest, 4L, 3343L);
        this.assertAccepted(highest, 10L, 3343857L);
    }

    @Test
    public void shouldKeepHighestDuringConcurrentOfferings() throws Throwable {
        final HighestTransactionId highest = new HighestTransactionId(-1L, -1L);
        Race race = new Race();
        int updaters = Math.max(2, Runtime.getRuntime().availableProcessors());
        final AtomicInteger accepted = new AtomicInteger();
        for (int i = 0; i < updaters; ++i) {
            final long id = i + 1;
            race.addContestant(new Runnable(){

                @Override
                public void run() {
                    if (highest.offer(id, id)) {
                        accepted.incrementAndGet();
                    }
                }
            });
        }
        race.go();
        Assert.assertTrue((accepted.get() > 0 ? 1 : 0) != 0);
        Assert.assertEquals((long)updaters, (long)highest.get().transactionId());
    }

    private void assertAccepted(HighestTransactionId highest, long txId, long checksum) {
        TransactionId current = highest.get();
        Assert.assertTrue((boolean)highest.offer(txId, checksum));
        Assert.assertTrue((txId > current.transactionId() ? 1 : 0) != 0);
    }

    private void assertRejected(HighestTransactionId highest, long txId, long checksum) {
        TransactionId current = highest.get();
        Assert.assertFalse((boolean)highest.offer(txId, checksum));
        Assert.assertEquals((Object)current, (Object)highest.get());
    }
}

