/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.DefaultIdGeneratorFactory;
import org.neo4j.kernel.IdGeneratorFactory;
import org.neo4j.kernel.IdType;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.store.AbstractDynamicStore;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.test.EphemeralFileSystemRule;
import org.neo4j.test.PageCacheRule;

public class AbstractDynamicStoreTest {
    private static final int BLOCK_SIZE = 60;
    @Rule
    public final EphemeralFileSystemRule fsr = new EphemeralFileSystemRule();
    @Rule
    public final PageCacheRule pageCacheRule = new PageCacheRule();
    private final File fileName = new File("store");
    private PageCache pageCache;
    private FileSystemAbstraction fs;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Before
    public void before() throws IOException {
        this.fs = this.fsr.get();
        this.pageCache = this.pageCacheRule.getPageCache((FileSystemAbstraction)this.fsr.get());
        try (StoreChannel channel = this.fs.create(this.fileName);){
            ByteBuffer buffer = ByteBuffer.allocate(4);
            buffer.putInt(60);
            buffer.flip();
            channel.write(buffer);
        }
    }

    @Test
    public void shouldRecognizeDesignatedInUseBit() throws Exception {
        try (AbstractDynamicStore store = this.newTestableDynamicStore();){
            byte otherBitsInTheInUseByte = 0;
            for (int i = 0; i < 8; ++i) {
                this.assertRecognizesByteAsInUse(store, otherBitsInTheInUseByte);
                otherBitsInTheInUseByte = (byte)(otherBitsInTheInUseByte << 1);
                otherBitsInTheInUseByte = (byte)(otherBitsInTheInUseByte | 1);
            }
        }
    }

    private void assertRecognizesByteAsInUse(AbstractDynamicStore store, byte inUseByte) {
        Assert.assertTrue((boolean)store.isInUse((byte)(inUseByte | 0x10)));
        Assert.assertFalse((boolean)store.isInUse((byte)(inUseByte & 0xFFFFFFEF)));
    }

    private AbstractDynamicStore newTestableDynamicStore() {
        DefaultIdGeneratorFactory idGeneratorFactory = new DefaultIdGeneratorFactory(this.fs);
        AbstractDynamicStore store = new AbstractDynamicStore(this.fileName, new Config(), IdType.ARRAY_BLOCK, (IdGeneratorFactory)idGeneratorFactory, this.pageCache, (LogProvider)NullLogProvider.getInstance(), 60){

            public void accept(RecordStore.Processor processor, DynamicRecord record) {
            }

            public String getTypeDescriptor() {
                return "TestDynamicStore";
            }
        };
        store.initialise(true);
        return store;
    }
}

