/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.factory;

import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.api.ReadOnlyTransactionCommitProcess;
import org.neo4j.kernel.impl.api.TransactionCommitProcess;
import org.neo4j.kernel.impl.api.TransactionRepresentationCommitProcess;
import org.neo4j.kernel.impl.api.TransactionRepresentationStoreApplier;
import org.neo4j.kernel.impl.api.index.IndexUpdatesValidator;
import org.neo4j.kernel.impl.factory.CommunityCommitProcessFactory;
import org.neo4j.kernel.impl.transaction.log.TransactionAppender;
import org.neo4j.kernel.impl.transaction.state.NeoStoreInjectedTransactionValidator;

public class CommunityCommitProcessFactoryTest {
    @Test
    public void createReadOnlyCommitProcess() {
        CommunityCommitProcessFactory factory = new CommunityCommitProcessFactory();
        Config config = new Config(MapUtil.stringMap((String[])new String[]{GraphDatabaseSettings.read_only.name(), "true"}));
        TransactionCommitProcess commitProcess = factory.create((TransactionAppender)Mockito.mock(TransactionAppender.class), (TransactionRepresentationStoreApplier)Mockito.mock(TransactionRepresentationStoreApplier.class), (NeoStoreInjectedTransactionValidator)Mockito.mock(NeoStoreInjectedTransactionValidator.class), (IndexUpdatesValidator)Mockito.mock(IndexUpdatesValidator.class), config);
        Assert.assertThat((Object)commitProcess, (Matcher)Matchers.instanceOf(ReadOnlyTransactionCommitProcess.class));
    }

    @Test
    public void createRegularCommitProcess() {
        CommunityCommitProcessFactory factory = new CommunityCommitProcessFactory();
        TransactionCommitProcess commitProcess = factory.create((TransactionAppender)Mockito.mock(TransactionAppender.class), (TransactionRepresentationStoreApplier)Mockito.mock(TransactionRepresentationStoreApplier.class), (NeoStoreInjectedTransactionValidator)Mockito.mock(NeoStoreInjectedTransactionValidator.class), (IndexUpdatesValidator)Mockito.mock(IndexUpdatesValidator.class), new Config());
        Assert.assertThat((Object)commitProcess, (Matcher)Matchers.instanceOf(TransactionRepresentationCommitProcess.class));
    }
}

