/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import org.junit.Assert;
import org.junit.Test;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.impl.AbstractNeo4jTestCase;

public class TestProperties
extends AbstractNeo4jTestCase {
    private static final int VALUE_RANGE_SPLIT = 20;

    @Test
    public void addAndRemovePropertiesWithinOneTransaction() throws Exception {
        Node node = this.getGraphDb().createNode();
        node.setProperty("name", (Object)"oscar");
        node.setProperty("favourite_numbers", (Object)new Long[]{1L, 2L, 3L});
        node.setProperty("favourite_colors", (Object)new String[]{"blue", "red"});
        node.removeProperty("favourite_colors");
        this.newTransaction();
        Assert.assertNotNull((Object)node.getProperty("favourite_numbers", null));
    }

    @Test
    public void addAndRemovePropertiesWithinOneTransaction2() throws Exception {
        Node node = this.getGraphDb().createNode();
        node.setProperty("foo", (Object)"bar");
        this.newTransaction();
        node.setProperty("foo2", (Object)"bar");
        node.removeProperty("foo");
        this.newTransaction();
        try {
            node.getProperty("foo");
            Assert.fail((String)"property should not exist");
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
    }

    @Test
    public void removeAndAddSameProperty() throws Exception {
        Node node = this.getGraphDb().createNode();
        node.setProperty("foo", (Object)"bar");
        this.newTransaction();
        node.removeProperty("foo");
        node.setProperty("foo", (Object)"bar");
        this.newTransaction();
        Assert.assertEquals((Object)"bar", (Object)node.getProperty("foo"));
        node.setProperty("foo", (Object)"bar");
        node.removeProperty("foo");
        this.newTransaction();
        Assert.assertNull((Object)node.getProperty("foo", null));
    }

    @Test
    public void removeSomeAndSetSome() throws Exception {
        Node node = this.getGraphDb().createNode();
        node.setProperty("remove me", (Object)"trash");
        this.newTransaction();
        node.removeProperty("remove me");
        node.setProperty("foo", (Object)"bar");
        node.setProperty("baz", (Object)17);
        this.newTransaction();
        Assert.assertEquals((Object)"bar", (Object)node.getProperty("foo"));
        Assert.assertEquals((Object)17, (Object)node.getProperty("baz"));
        Assert.assertNull((Object)node.getProperty("remove me", null));
    }

    @Test
    public void removeOneOfThree() throws Exception {
        Node node = this.getGraphDb().createNode();
        node.setProperty("1", (Object)1);
        node.setProperty("2", (Object)2);
        node.setProperty("3", (Object)3);
        this.newTransaction();
        node.removeProperty("2");
        this.newTransaction();
        Assert.assertNull((Object)node.getProperty("2", null));
    }

    @Test
    public void testLongPropertyValues() throws Exception {
        Node n = this.getGraphDb().createNode();
        this.setPropertyAndAssertIt(n, -134217728L);
        this.setPropertyAndAssertIt(n, -134217729L);
    }

    @Test
    public void testIntPropertyValues() throws Exception {
        Node n = this.getGraphDb().createNode();
        this.setPropertyAndAssertIt(n, -134217728);
        this.setPropertyAndAssertIt(n, -134217729);
    }

    @Test
    public void booleanRange() throws Exception {
        Node node = this.getGraphDb().createNode();
        this.setPropertyAndAssertIt(node, false);
        this.setPropertyAndAssertIt(node, true);
    }

    @Test
    public void byteRange() throws Exception {
        Node node = this.getGraphDb().createNode();
        int stride = 6;
        byte i = -128;
        while (i < 127) {
            this.setPropertyAndAssertIt(node, i);
            i = i > 0 && 127 - i < stride ? (byte)127 : (byte)(i + stride);
        }
    }

    @Test
    public void charRange() throws Exception {
        Node node = this.getGraphDb().createNode();
        int stride = 3276;
        char i = '\u0000';
        while (i < '\uffff') {
            this.setPropertyAndAssertIt(node, Character.valueOf(i));
            i = i > '\u0000' && 65535 - i < stride ? (char)65535 : (char)(i + stride);
        }
    }

    @Test
    public void shortRange() throws Exception {
        Node node = this.getGraphDb().createNode();
        int stride = 1638;
        short i = Short.MIN_VALUE;
        while (i < Short.MAX_VALUE) {
            this.setPropertyAndAssertIt(node, i);
            i = i > 0 && Short.MAX_VALUE - i < stride ? (short)Short.MAX_VALUE : (short)(i + stride);
        }
    }

    @Test
    public void intRange() throws Exception {
        Node node = this.getGraphDb().createNode();
        int stride = 0x6666666;
        int i = Integer.MIN_VALUE;
        while (i < Integer.MAX_VALUE) {
            this.setPropertyAndAssertIt(node, i);
            i = i > 0 && Integer.MAX_VALUE - i < stride ? Integer.MAX_VALUE : i + stride;
        }
    }

    @Test
    public void longRange() throws Exception {
        Node node = this.getGraphDb().createNode();
        long stride = 0x666666666666666L;
        long i = Long.MIN_VALUE;
        while (i < Long.MAX_VALUE) {
            this.setPropertyAndAssertIt(node, i);
            i = i > 0L && Long.MAX_VALUE - i < stride ? Long.MAX_VALUE : i + stride;
        }
    }

    @Test
    public void floatRange() throws Exception {
        Node node = this.getGraphDb().createNode();
        float stride = 16.0f;
        for (float i = Float.MIN_VALUE; i < Float.MAX_VALUE; i *= stride) {
            this.setPropertyAndAssertIt(node, Float.valueOf(i));
            this.setPropertyAndAssertIt(node, Float.valueOf(-i));
        }
    }

    @Test
    public void doubleRange() throws Exception {
        Node node = this.getGraphDb().createNode();
        double stride = 4194304.0;
        for (double i = Double.MIN_VALUE; i < Double.MAX_VALUE; i *= stride) {
            this.setPropertyAndAssertIt(node, i);
            this.setPropertyAndAssertIt(node, -i);
        }
    }

    private void setPropertyAndAssertIt(Node node, Object value) {
        node.setProperty("key", value);
        Assert.assertEquals((Object)value, (Object)node.getProperty("key"));
    }

    @Test
    public void loadManyProperties() throws Exception {
        Node node = this.getGraphDb().createNode();
        for (int i = 0; i < 200; ++i) {
            node.setProperty("property " + i, (Object)"value");
        }
        this.newTransaction();
        Assert.assertEquals((Object)"value", (Object)node.getProperty("property 0"));
    }

    @Test
    public void name() throws Exception {
        Node node = this.getGraphDb().createNode();
        node.setProperty("name", (Object)"yo");
        node.getProperty("name");
        this.commit();
        try (Transaction tx = this.getGraphDb().beginTx();){
            node.getProperty("name");
            tx.success();
        }
    }
}

