/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.index;

import java.util.Arrays;
import java.util.Collections;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.neo4j.kernel.api.index.IndexAccessorCompatibility;
import org.neo4j.kernel.api.index.IndexProviderCompatibilityTestSuite;
import org.neo4j.kernel.api.index.NodePropertyUpdate;

@Ignore(value="Not a test. This is a compatibility suite that provides test cases for verifying SchemaIndexProvider implementations. Each index provider that is to be tested by this suite must create their own test class extending IndexProviderCompatibilityTestSuite. The @Ignore annotation doesn't prevent these tests to run, it rather removes some annoying errors or warnings in some IDEs about test classes needing a public zero-arg constructor.")
public class NonUniqueIndexAccessorCompatibility
extends IndexAccessorCompatibility {
    private static final int PROPERTY_KEY_ID = 100;

    public NonUniqueIndexAccessorCompatibility(IndexProviderCompatibilityTestSuite testSuite) {
        super(testSuite, false);
    }

    @Ignore(value="Invalid assumption since we currently must rely on close throwing exception for injectedtransactions that violate a constraint")
    @Test
    public void closingAnOnlineIndexUpdaterMustNotThrowEvenIfItHasBeenFedConflictingData() throws Exception {
        this.updateAndCommit(Arrays.asList(NodePropertyUpdate.add((long)1L, (int)100, (Object)"a", (long[])new long[]{1000L}), NodePropertyUpdate.add((long)2L, (int)100, (Object)"a", (long[])new long[]{1000L})));
        Assert.assertThat(this.getAllNodesWithProperty("a"), (Matcher)Matchers.equalTo(Arrays.asList(1L, 2L)));
    }

    @Test
    public void testIndexSeekAndScan() throws Exception {
        this.updateAndCommit(Arrays.asList(NodePropertyUpdate.add((long)1L, (int)100, (Object)"a", (long[])new long[]{1000L}), NodePropertyUpdate.add((long)2L, (int)100, (Object)"a", (long[])new long[]{1000L}), NodePropertyUpdate.add((long)3L, (int)100, (Object)"b", (long[])new long[]{1000L})));
        Assert.assertThat(this.getAllNodesWithProperty("a"), (Matcher)Matchers.equalTo(Arrays.asList(1L, 2L)));
        Assert.assertThat(this.getAllNodes(), (Matcher)Matchers.equalTo(Arrays.asList(1L, 2L, 3L)));
    }

    @Test
    public void testIndexRangeSeekByNumberWithDuplicates() throws Exception {
        this.updateAndCommit(Arrays.asList(NodePropertyUpdate.add((long)1L, (int)100, (Object)-5, (long[])new long[]{1000L}), NodePropertyUpdate.add((long)2L, (int)100, (Object)-5, (long[])new long[]{1000L}), NodePropertyUpdate.add((long)3L, (int)100, (Object)0, (long[])new long[]{1000L}), NodePropertyUpdate.add((long)4L, (int)100, (Object)5, (long[])new long[]{1000L}), NodePropertyUpdate.add((long)5L, (int)100, (Object)5, (long[])new long[]{1000L})));
        Assert.assertThat(this.getAllNodesFromInclusiveIndexSeekByNumber(-5, 5), (Matcher)Matchers.equalTo(Arrays.asList(1L, 2L, 3L, 4L, 5L)));
        Assert.assertThat(this.getAllNodesFromInclusiveIndexSeekByNumber(-3, -1), (Matcher)Matchers.equalTo((Object)Collections.EMPTY_LIST));
        Assert.assertThat(this.getAllNodesFromInclusiveIndexSeekByNumber(-5, 4), (Matcher)Matchers.equalTo(Arrays.asList(1L, 2L, 3L)));
        Assert.assertThat(this.getAllNodesFromInclusiveIndexSeekByNumber(-4, 5), (Matcher)Matchers.equalTo(Arrays.asList(3L, 4L, 5L)));
        Assert.assertThat(this.getAllNodesFromInclusiveIndexSeekByNumber(-5, 5), (Matcher)Matchers.equalTo(Arrays.asList(1L, 2L, 3L, 4L, 5L)));
    }

    @Test
    public void testIndexRangeSeekByStringWithDuplicates() throws Exception {
        this.updateAndCommit(Arrays.asList(NodePropertyUpdate.add((long)1L, (int)100, (Object)"Anna", (long[])new long[]{1000L}), NodePropertyUpdate.add((long)2L, (int)100, (Object)"Anna", (long[])new long[]{1000L}), NodePropertyUpdate.add((long)3L, (int)100, (Object)"Bob", (long[])new long[]{1000L}), NodePropertyUpdate.add((long)4L, (int)100, (Object)"William", (long[])new long[]{1000L}), NodePropertyUpdate.add((long)5L, (int)100, (Object)"William", (long[])new long[]{1000L})));
        Assert.assertThat(this.getAllNodesFromIndexSeekByString("Anna", false, "William", false), (Matcher)Matchers.equalTo(Collections.singletonList(3L)));
        Assert.assertThat(this.getAllNodesFromIndexSeekByString("Arabella", false, "Bob", false), (Matcher)Matchers.equalTo((Object)Collections.EMPTY_LIST));
        Assert.assertThat(this.getAllNodesFromIndexSeekByString("Anna", true, "William", false), (Matcher)Matchers.equalTo(Arrays.asList(1L, 2L, 3L)));
        Assert.assertThat(this.getAllNodesFromIndexSeekByString("Anna", false, "William", true), (Matcher)Matchers.equalTo(Arrays.asList(3L, 4L, 5L)));
        Assert.assertThat(this.getAllNodesFromIndexSeekByString("Anna", true, "William", true), (Matcher)Matchers.equalTo(Arrays.asList(1L, 2L, 3L, 4L, 5L)));
    }

    @Test
    public void testIndexRangeSeekByPrefixWithDuplicates() throws Exception {
        this.updateAndCommit(Arrays.asList(NodePropertyUpdate.add((long)1L, (int)100, (Object)"a", (long[])new long[]{1000L}), NodePropertyUpdate.add((long)2L, (int)100, (Object)"A", (long[])new long[]{1000L}), NodePropertyUpdate.add((long)3L, (int)100, (Object)"apa", (long[])new long[]{1000L}), NodePropertyUpdate.add((long)4L, (int)100, (Object)"apa", (long[])new long[]{1000L}), NodePropertyUpdate.add((long)5L, (int)100, (Object)"apa", (long[])new long[]{1000L})));
        Assert.assertThat(this.getAllNodesFromIndexSeekByPrefix("a"), (Matcher)Matchers.equalTo(Arrays.asList(1L, 3L, 4L, 5L)));
        Assert.assertThat(this.getAllNodesFromIndexSeekByPrefix("apa"), (Matcher)Matchers.equalTo(Arrays.asList(3L, 4L, 5L)));
    }
}

