/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.DynamicRelationshipType;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Neo4jMatchers;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.event.TransactionData;
import org.neo4j.graphdb.event.TransactionEventHandler;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.test.DatabaseRule;
import org.neo4j.test.ImpermanentDatabaseRule;

public class TestTransactionEventDeadlocks {
    @Rule
    public DatabaseRule database = new ImpermanentDatabaseRule();

    @Test
    public void canAvoidDeadlockThatWouldHappenIfTheRelationshipTypeCreationTransactionModifiedData() throws Exception {
        GraphDatabaseService graphdb = this.database.getGraphDatabaseService();
        Node node = null;
        try (Transaction tx = graphdb.beginTx();){
            node = graphdb.createNode();
            node.setProperty("counter", (Object)0L);
            tx.success();
        }
        graphdb.registerTransactionEventHandler((TransactionEventHandler)new RelationshipCounterTransactionEventHandler(node));
        tx = graphdb.beginTx();
        var4_4 = null;
        try {
            node.setProperty("state", (Object)"not broken yet");
            node.createRelationshipTo(graphdb.createNode(), (RelationshipType)DynamicRelationshipType.withName((String)"TEST"));
            node.removeProperty("state");
            tx.success();
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var4_4 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable x2) {
                        var4_4.addSuppressed(x2);
                    }
                } else {
                    tx.close();
                }
            }
        }
        Assert.assertThat((Object)node, Neo4jMatchers.inTx(graphdb, Neo4jMatchers.hasProperty("counter").withValue(1L)));
    }

    private static class RelationshipCounterTransactionEventHandler
    implements TransactionEventHandler<Void> {
        private final Node node;

        public RelationshipCounterTransactionEventHandler(Node node) {
            this.node = node;
        }

        public Void beforeCommit(TransactionData data) throws Exception {
            if (IteratorUtil.count((Iterable)data.createdRelationships()) == 0) {
                return null;
            }
            this.node.setProperty("counter", (Object)((Long)this.node.removeProperty("counter") + 1L));
            return null;
        }

        public void afterCommit(TransactionData data, Void state) {
        }

        public void afterRollback(TransactionData data, Void state) {
        }
    }
}

