/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.DynamicLabel;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Transaction;
import org.neo4j.io.ByteUnit;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.DefaultFileSystemAbstraction;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.storemigration.LogFiles;
import org.neo4j.test.TargetDirectory;
import org.neo4j.test.TestGraphDatabaseFactory;

public class RecoveryIT {
    @Rule
    public final TargetDirectory.TestDirectory directory = TargetDirectory.testDirForTest(this.getClass());

    @Test
    public void idGeneratorsRebuildAfterRecovery() throws IOException {
        GraphDatabaseService database = this.startDatabase(this.directory.graphDbDir());
        int numberOfNodes = 10;
        try (Transaction transaction = database.beginTx();){
            for (int nodeIndex = 0; nodeIndex < numberOfNodes; ++nodeIndex) {
                database.createNode();
            }
            transaction.success();
        }
        File restoreDbStoreDir = this.copyTransactionLogs();
        GraphDatabaseService recoveredDatabase = this.startDatabase(restoreDbStoreDir);
        NeoStores neoStore = (NeoStores)((GraphDatabaseAPI)recoveredDatabase).getDependencyResolver().resolveDependency(NeoStores.class);
        Assert.assertEquals((long)numberOfNodes, (long)neoStore.getNodeStore().getHighId());
        database.shutdown();
        recoveredDatabase.shutdown();
    }

    @Test
    public void shouldRecoverIdsCorrectlyWhenWeCreateAndDeleteANodeInTheSameRecoveryRun() throws IOException {
        Node node;
        GraphDatabaseService database = this.startDatabase(this.directory.graphDbDir());
        Label testLabel = DynamicLabel.label((String)"testLabel");
        String propertyToDelete = "propertyToDelete";
        String validPropertyName = "validProperty";
        try (Transaction transaction = database.beginTx();){
            node = database.createNode();
            node.addLabel(testLabel);
            transaction.success();
        }
        transaction = database.beginTx();
        var6_6 = null;
        try {
            node = this.findNodeByLabel(database, testLabel);
            node.setProperty("propertyToDelete", (Object)this.createLongString());
            node.setProperty("validProperty", (Object)this.createLongString());
            transaction.success();
        }
        catch (Throwable x2) {
            var6_6 = x2;
            throw x2;
        }
        finally {
            if (transaction != null) {
                if (var6_6 != null) {
                    try {
                        transaction.close();
                    }
                    catch (Throwable x2) {
                        var6_6.addSuppressed(x2);
                    }
                } else {
                    transaction.close();
                }
            }
        }
        transaction = database.beginTx();
        var6_6 = null;
        try {
            node = this.findNodeByLabel(database, testLabel);
            node.removeProperty("propertyToDelete");
            transaction.success();
        }
        catch (Throwable x2) {
            var6_6 = x2;
            throw x2;
        }
        finally {
            if (transaction != null) {
                if (var6_6 != null) {
                    try {
                        transaction.close();
                    }
                    catch (Throwable x2) {
                        var6_6.addSuppressed(x2);
                    }
                } else {
                    transaction.close();
                }
            }
        }
        File restoreDbStoreDir = this.copyTransactionLogs();
        GraphDatabaseService recoveredDatabase = this.startDatabase(restoreDbStoreDir);
        try (Transaction ignored = recoveredDatabase.beginTx();){
            Node node2 = this.findNodeByLabel(recoveredDatabase, testLabel);
            Assert.assertFalse((boolean)node2.hasProperty("propertyToDelete"));
            Assert.assertTrue((boolean)node2.hasProperty("validProperty"));
        }
        database.shutdown();
        recoveredDatabase.shutdown();
    }

    private Node findNodeByLabel(GraphDatabaseService database, Label testLabel) {
        try (ResourceIterator nodes = database.findNodes(testLabel);){
            Node node = (Node)nodes.next();
            return node;
        }
    }

    private String createLongString() {
        Object[] strings = new String[(int)ByteUnit.kibiBytes((long)2L)];
        Arrays.fill(strings, "a");
        return Arrays.toString(strings);
    }

    private GraphDatabaseService startDatabase(File storeDir) {
        return new TestGraphDatabaseFactory().newEmbeddedDatabase(storeDir.getAbsolutePath());
    }

    private File copyTransactionLogs() throws IOException {
        File restoreDbStoreDir = this.directory.directory("restore-db");
        LogFiles.move((FileSystemAbstraction)new DefaultFileSystemAbstraction(), (File)this.directory.graphDbDir(), (File)restoreDbStoreDir);
        return restoreDbStoreDir;
    }
}

