/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api.security;

import java.util.Collections;
import java.util.Set;
import java.util.function.Supplier;
import org.eclipse.collections.api.set.primitive.IntSet;
import org.eclipse.collections.impl.factory.primitive.IntSets;
import org.neo4j.internal.kernel.api.RelTypeSupplier;
import org.neo4j.internal.kernel.api.TokenSet;
import org.neo4j.internal.kernel.api.security.PermissionState;
import org.neo4j.internal.kernel.api.security.PrivilegeAction;
import org.neo4j.internal.kernel.api.security.ReadSecurityPropertyProvider;
import org.neo4j.storageengine.api.PropertySelection;

public interface AccessMode {
    public boolean allowsWrites();

    public PermissionState allowsTokenCreates(PrivilegeAction var1);

    public boolean allowsSchemaWrites();

    public PermissionState allowsSchemaWrites(PrivilegeAction var1);

    public boolean allowsShowIndex();

    public boolean allowsShowConstraint();

    public boolean allowsTraverseAllLabels();

    public boolean allowsTraverseAllNodesWithLabel(long var1);

    public boolean disallowsTraverseLabel(long var1);

    public boolean allowsTraverseNode(long ... var1);

    public IntSet getTraverseSecurityProperties(long[] var1);

    public boolean hasApplicableTraverseAllowPropertyRules(long var1);

    public boolean allowsTraverseNodeWithPropertyRules(ReadSecurityPropertyProvider var1, long ... var2);

    public boolean hasTraversePropertyRules();

    public boolean allowsTraverseAllRelTypes();

    public boolean allowsTraverseRelType(int var1);

    public boolean disallowsTraverseRelType(int var1);

    public boolean allowsReadPropertyAllLabels(int var1);

    public boolean disallowsReadPropertyForSomeLabel(int var1);

    public boolean allowsReadNodeProperties(Supplier<TokenSet> var1, int[] var2, ReadSecurityPropertyProvider var3);

    public boolean allowsReadNodeProperties(Supplier<TokenSet> var1, int[] var2);

    public boolean allowsReadNodeProperty(Supplier<TokenSet> var1, int var2, ReadSecurityPropertyProvider var3);

    public boolean allowsReadNodeProperty(Supplier<TokenSet> var1, int var2);

    public boolean allowsReadPropertyAllRelTypes(int var1);

    public boolean allowsReadRelationshipProperty(RelTypeSupplier var1, int var2);

    public boolean allowsSeePropertyKeyToken(int var1);

    public boolean hasPropertyReadRules();

    public boolean hasPropertyReadRules(int ... var1);

    public IntSet getReadSecurityProperties(int var1);

    public IntSet getAllReadSecurityProperties();

    public PropertySelection getSecurityPropertySelection(PropertySelection var1);

    public PermissionState allowsExecuteProcedure(int var1);

    public PermissionState shouldBoostProcedure(int var1);

    public PermissionState allowsExecuteFunction(int var1);

    public PermissionState shouldBoostFunction(int var1);

    public PermissionState allowsExecuteAggregatingFunction(int var1);

    public PermissionState shouldBoostAggregatingFunction(int var1);

    public PermissionState allowsShowSetting(String var1);

    public boolean allowsSetLabel(long var1);

    public boolean allowsRemoveLabel(long var1);

    public boolean allowsCreateNode(int[] var1);

    public boolean allowsDeleteNode(Supplier<TokenSet> var1);

    public boolean allowsCreateRelationship(int var1);

    public boolean allowsDeleteRelationship(int var1);

    public boolean allowsSetProperty(Supplier<TokenSet> var1, int var2);

    public boolean allowsSetProperty(RelTypeSupplier var1, int var2);

    public PermissionState allowsLoadAllData();

    public String name();

    default public Set<String> roles() {
        return Collections.emptySet();
    }

    default public boolean isOverridden() {
        return false;
    }

    default public boolean isCacheable() {
        return false;
    }

    public static enum Static implements AccessMode
    {
        ACCESS(false, false, false, false, false),
        CREDENTIALS_EXPIRED(false, false, false, false, false),
        READ(true, false, false, false, false),
        WRITE_ONLY(false, true, false, false, false),
        WRITE(true, true, false, false, false),
        TOKEN_WRITE(true, true, true, false, false),
        SCHEMA(true, true, true, true, false),
        FULL(true, true, true, true, true);

        private final boolean read;
        private final boolean write;
        private final boolean token;
        private final boolean schema;
        private final boolean procedureBoost;

        private Static(boolean read, boolean write, boolean token, boolean schema, boolean procedureBoost) {
            this.read = read;
            this.write = write;
            this.token = token;
            this.schema = schema;
            this.procedureBoost = procedureBoost;
        }

        @Override
        public boolean allowsWrites() {
            return this.write;
        }

        @Override
        public PermissionState allowsTokenCreates(PrivilegeAction action) {
            return PermissionState.fromAllowList(this.token);
        }

        @Override
        public boolean allowsSchemaWrites() {
            return this.schema;
        }

        @Override
        public PermissionState allowsSchemaWrites(PrivilegeAction action) {
            return PermissionState.fromAllowList(this.schema);
        }

        @Override
        public boolean allowsShowIndex() {
            return this.schema;
        }

        @Override
        public boolean allowsShowConstraint() {
            return this.schema;
        }

        @Override
        public boolean allowsTraverseAllLabels() {
            return this.read;
        }

        @Override
        public boolean allowsTraverseAllNodesWithLabel(long label) {
            return this.read;
        }

        @Override
        public boolean disallowsTraverseLabel(long label) {
            return false;
        }

        @Override
        public boolean allowsTraverseNode(long ... labels) {
            return this.read;
        }

        @Override
        public IntSet getTraverseSecurityProperties(long[] labels) {
            return IntSets.immutable.empty();
        }

        @Override
        public boolean hasApplicableTraverseAllowPropertyRules(long label) {
            return this.read;
        }

        @Override
        public boolean allowsTraverseNodeWithPropertyRules(ReadSecurityPropertyProvider propertyProvider, long ... labels) {
            return this.read;
        }

        @Override
        public boolean hasTraversePropertyRules() {
            return false;
        }

        @Override
        public boolean allowsTraverseAllRelTypes() {
            return this.read;
        }

        @Override
        public boolean allowsTraverseRelType(int relType) {
            return this.read;
        }

        @Override
        public boolean disallowsTraverseRelType(int relType) {
            return false;
        }

        @Override
        public boolean allowsReadPropertyAllLabels(int propertyKey) {
            return this.read;
        }

        @Override
        public boolean disallowsReadPropertyForSomeLabel(int propertyKey) {
            return false;
        }

        @Override
        public boolean allowsReadNodeProperties(Supplier<TokenSet> labels, int[] propertyKeys, ReadSecurityPropertyProvider propertyProvider) {
            return this.read;
        }

        @Override
        public boolean allowsReadNodeProperties(Supplier<TokenSet> labels, int[] propertyKeys) {
            return this.read;
        }

        @Override
        public boolean allowsReadNodeProperty(Supplier<TokenSet> labels, int propertyKey, ReadSecurityPropertyProvider propertyProvider) {
            return this.read;
        }

        @Override
        public boolean allowsReadNodeProperty(Supplier<TokenSet> labels, int propertyKey) {
            return this.read;
        }

        @Override
        public boolean allowsReadPropertyAllRelTypes(int propertyKey) {
            return this.read;
        }

        @Override
        public boolean allowsReadRelationshipProperty(RelTypeSupplier relType, int propertyKey) {
            return this.read;
        }

        @Override
        public IntSet getAllReadSecurityProperties() {
            return IntSets.immutable.empty();
        }

        @Override
        public PropertySelection getSecurityPropertySelection(PropertySelection selection) {
            return PropertySelection.NO_PROPERTIES;
        }

        @Override
        public boolean allowsSeePropertyKeyToken(int propertyKey) {
            return this.read;
        }

        @Override
        public boolean hasPropertyReadRules() {
            return false;
        }

        @Override
        public boolean hasPropertyReadRules(int ... propertyKeys) {
            return false;
        }

        @Override
        public IntSet getReadSecurityProperties(int propertyKey) {
            return IntSets.immutable.empty();
        }

        @Override
        public PermissionState allowsExecuteProcedure(int procedureId) {
            return PermissionState.EXPLICIT_GRANT;
        }

        @Override
        public PermissionState shouldBoostProcedure(int procedureId) {
            return PermissionState.fromAllowList(this.procedureBoost);
        }

        @Override
        public PermissionState allowsExecuteFunction(int id) {
            return PermissionState.EXPLICIT_GRANT;
        }

        @Override
        public PermissionState shouldBoostFunction(int id) {
            return PermissionState.fromAllowList(this.procedureBoost);
        }

        @Override
        public PermissionState allowsExecuteAggregatingFunction(int id) {
            return PermissionState.EXPLICIT_GRANT;
        }

        @Override
        public PermissionState shouldBoostAggregatingFunction(int id) {
            return PermissionState.fromAllowList(this.procedureBoost);
        }

        @Override
        public PermissionState allowsShowSetting(String setting) {
            return PermissionState.EXPLICIT_GRANT;
        }

        @Override
        public boolean allowsSetLabel(long labelId) {
            return this.write;
        }

        @Override
        public boolean allowsRemoveLabel(long labelId) {
            return this.write;
        }

        @Override
        public boolean allowsCreateNode(int[] labelIds) {
            return this.write;
        }

        @Override
        public boolean allowsDeleteNode(Supplier<TokenSet> labelSupplier) {
            return this.write;
        }

        @Override
        public boolean allowsCreateRelationship(int relType) {
            return this.write;
        }

        @Override
        public boolean allowsDeleteRelationship(int relType) {
            return this.write;
        }

        @Override
        public boolean allowsSetProperty(Supplier<TokenSet> labels, int propertyKey) {
            return this.write;
        }

        @Override
        public boolean allowsSetProperty(RelTypeSupplier relType, int propertyKey) {
            return this.write;
        }

        @Override
        public PermissionState allowsLoadAllData() {
            return PermissionState.fromAllowList(this.read);
        }
    }
}

