/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api.procs;

import java.util.Arrays;
import java.util.List;
import org.neo4j.internal.helpers.collection.Iterables;

public class QualifiedName {
    private final String[] namespace;
    private final String name;
    private final String description;

    public QualifiedName(List<String> namespace, String name) {
        this(namespace.toArray(new String[0]), name);
    }

    public QualifiedName(String[] namespace, String name) {
        this.namespace = namespace;
        this.name = name;
        this.description = QualifiedName.buildDescription(namespace, name);
    }

    public String[] namespace() {
        return this.namespace;
    }

    public String name() {
        return this.name;
    }

    public String toString() {
        return this.description;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QualifiedName that = (QualifiedName)o;
        return Arrays.equals(this.namespace, that.namespace) && this.name.equals(that.name);
    }

    public int hashCode() {
        return 31 * Arrays.hashCode(this.namespace) + this.name.hashCode();
    }

    private static String buildDescription(String[] namespace, String name) {
        String strNamespace = namespace.length > 0 ? Iterables.toString(Arrays.asList(namespace), (String)".") + "." : "";
        return String.format("%s%s", strNamespace, name);
    }
}

