/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport;

import org.neo4j.token.TokenHolders;

public interface ReadBehaviour {
    public static final ReadBehaviour INCLUSIVE_STRICT = new Adapter(){

        @Override
        public void error(String format, Object ... parameters) {
            throw new RuntimeException(String.format(format, parameters));
        }

        @Override
        public void error(Throwable e, String format, Object ... parameters) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(String.format(format, parameters), e);
        }
    };

    public boolean shouldIncludeNode(String[] var1);

    public boolean shouldIncludeRelationship(String var1);

    public String[] filterLabels(String[] var1);

    public boolean shouldIncludeNodeProperty(String var1, String[] var2);

    public boolean shouldIncludeRelationshipProperty(String var1, String var2);

    public void unused();

    public void removed();

    public void error(String var1, Object ... var2);

    public void error(Throwable var1, String var2, Object ... var3);

    public TokenHolders decorateTokenHolders(TokenHolders var1);

    public static class Adapter
    implements ReadBehaviour {
        @Override
        public boolean shouldIncludeNode(String[] labels) {
            return true;
        }

        @Override
        public boolean shouldIncludeRelationship(String relationshipType) {
            return true;
        }

        @Override
        public String[] filterLabels(String[] labels) {
            return labels;
        }

        @Override
        public boolean shouldIncludeNodeProperty(String propertyKey, String[] labels) {
            return true;
        }

        @Override
        public boolean shouldIncludeRelationshipProperty(String propertyKey, String relationshipType) {
            return true;
        }

        @Override
        public void unused() {
        }

        @Override
        public void removed() {
        }

        @Override
        public void error(String format, Object ... parameters) {
        }

        @Override
        public void error(Throwable e, String format, Object ... parameters) {
        }

        @Override
        public TokenHolders decorateTokenHolders(TokenHolders actual) {
            return actual;
        }
    }
}

