/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.storageengine.api.schema;

import org.neo4j.internal.kernel.api.IndexCapability;
import org.neo4j.internal.kernel.api.TokenNameLookup;
import org.neo4j.internal.kernel.api.schema.SchemaUtil;
import org.neo4j.storageengine.api.schema.CapableIndexDescriptor;
import org.neo4j.storageengine.api.schema.IndexDescriptor;
import org.neo4j.storageengine.api.schema.SchemaRule;

public class StoreIndexDescriptor
extends IndexDescriptor
implements SchemaRule {
    private final long id;
    private final Long owningConstraintId;
    private final String name;

    protected StoreIndexDescriptor(StoreIndexDescriptor indexDescriptor) {
        super(indexDescriptor);
        this.id = indexDescriptor.id;
        this.owningConstraintId = indexDescriptor.owningConstraintId;
        this.name = indexDescriptor.name;
    }

    StoreIndexDescriptor(IndexDescriptor descriptor, long id) {
        this(descriptor, id, null);
    }

    StoreIndexDescriptor(IndexDescriptor descriptor, long id, Long owningConstraintId) {
        super(descriptor);
        this.id = id;
        this.name = descriptor.userSuppliedName.map(SchemaRule::checkName).orElse("index_" + id);
        if (descriptor.providerDescriptor() == null) {
            throw new IllegalArgumentException("null provider descriptor prohibited");
        }
        if (owningConstraintId != null) {
            this.assertValidId(owningConstraintId, "owning constraint id");
        }
        this.owningConstraintId = owningConstraintId;
    }

    public Long getOwningConstraint() {
        if (!this.canSupportUniqueConstraint()) {
            throw new IllegalStateException("Can only get owner from constraint indexes.");
        }
        return this.owningConstraintId;
    }

    public boolean canSupportUniqueConstraint() {
        return this.type() == IndexDescriptor.Type.UNIQUE;
    }

    public boolean isIndexWithoutOwningConstraint() {
        return this.canSupportUniqueConstraint() && this.getOwningConstraint() == null;
    }

    public StoreIndexDescriptor withOwningConstraint(Long constraintId) {
        if (!this.canSupportUniqueConstraint()) {
            throw new IllegalStateException(this + " is not a constraint index");
        }
        return new StoreIndexDescriptor(this, this.id, constraintId);
    }

    public CapableIndexDescriptor withoutCapabilities() {
        return new CapableIndexDescriptor(this, IndexCapability.NO_CAPABILITY);
    }

    @Override
    public String toString() {
        return this.toString(SchemaUtil.idTokenNameLookup);
    }

    public String toString(TokenNameLookup tokenNameLookup) {
        String ownerString = "";
        if (this.canSupportUniqueConstraint()) {
            ownerString = ", owner=" + this.owningConstraintId;
        }
        return "IndexRule[id=" + this.id + ", descriptor=" + this.userDescription(tokenNameLookup) + ", provider=" + this.providerDescriptor() + ownerString + "]";
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }
}

