/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.utils;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.neo4j.driver.v1.types.Path;
import org.neo4j.jdbc.utils.DataConverterUtils;

public class PathSerializer
extends JsonSerializer<Path> {
    @Override
    public void serialize(Path value, JsonGenerator jsonGenerator, SerializerProvider serializers) throws IOException {
        List<Map<String, Object>> list = PathSerializer.toPath(value);
        jsonGenerator.writeObject(list);
    }

    public static List<Map<String, Object>> toPath(Path value) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        list.add(DataConverterUtils.nodeToMap(value.start()));
        for (Path.Segment s : value) {
            list.add(DataConverterUtils.relationshipToMap(s.relationship()));
            list.add(DataConverterUtils.nodeToMap(s.end()));
        }
        return list;
    }
}

