/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.utils;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.neo4j.driver.internal.InternalIsoDuration;
import org.neo4j.driver.internal.value.DateTimeValue;
import org.neo4j.driver.internal.value.DateValue;
import org.neo4j.driver.internal.value.LocalDateTimeValue;
import org.neo4j.driver.internal.value.LocalTimeValue;
import org.neo4j.driver.internal.value.TimeValue;
import org.neo4j.driver.v1.Value;
import org.neo4j.driver.v1.types.Node;
import org.neo4j.driver.v1.types.Path;
import org.neo4j.driver.v1.types.Point;
import org.neo4j.driver.v1.types.Relationship;
import org.neo4j.jdbc.utils.PathSerializer;

public class DataConverterUtils {
    public static Time valueToTime(Value value) {
        return DataConverterUtils.valueToTime(value, Calendar.getInstance());
    }

    public static Time valueToTime(Value value, Calendar cal) {
        if (value.isNull()) {
            return null;
        }
        if (value instanceof TimeValue) {
            ZoneOffset zoneOffset = ZoneOffset.ofTotalSeconds(cal.get(15) / 1000);
            TimeValue timeValue = (TimeValue)value;
            OffsetTime offsetTime = timeValue.asOffsetTime().withOffsetSameInstant(zoneOffset);
            return DataConverterUtils.offsetTimeToTime(offsetTime);
        }
        if (value instanceof LocalTimeValue) {
            return DataConverterUtils.localTimeToTime(((LocalTimeValue)value).asLocalTime());
        }
        return null;
    }

    public static Time localTimeToTime(LocalTime localTime) {
        Time time = Time.valueOf(localTime);
        time.setTime(time.getTime() + (long)localTime.getNano() / 1000000L);
        return time;
    }

    public static Time offsetTimeToTime(OffsetTime offsetTime) {
        return DataConverterUtils.localTimeToTime(offsetTime.toLocalTime());
    }

    public static Date valueToDate(Value value) {
        if (value.isNull()) {
            return null;
        }
        if (value instanceof DateValue) {
            return DataConverterUtils.localDateToDate(((DateValue)value).asLocalDate());
        }
        return null;
    }

    public static Date localDateToDate(LocalDate localDate) {
        return Date.valueOf(localDate);
    }

    public static Timestamp valueToTimestamp(Value value) {
        return DataConverterUtils.valueToTimestamp(value, ZoneId.systemDefault());
    }

    public static Timestamp valueToTimestamp(Value value, ZoneId zone) {
        if (value.isNull()) {
            return null;
        }
        if (value instanceof DateTimeValue) {
            return DataConverterUtils.zonedDateTimeToTimestamp(value.asZonedDateTime().withZoneSameInstant(zone));
        }
        if (value instanceof LocalDateTimeValue) {
            return DataConverterUtils.localDateTimeToTimestamp(value.asLocalDateTime());
        }
        return null;
    }

    public static Timestamp localDateTimeToTimestamp(LocalDateTime ldt) {
        return Timestamp.valueOf(ldt);
    }

    public static Timestamp zonedDateTimeToTimestamp(ZonedDateTime zdt) {
        return new Timestamp(zdt.toInstant().toEpochMilli());
    }

    public static Object convertObject(Object value) {
        Object converted = value;
        if (value instanceof List) {
            return DataConverterUtils.convertList((List)value);
        }
        if (value instanceof ZonedDateTime) {
            return DataConverterUtils.zonedDateTimeToTimestamp((ZonedDateTime)value);
        }
        if (value instanceof LocalDateTime) {
            return DataConverterUtils.localDateTimeToTimestamp((LocalDateTime)value);
        }
        if (value instanceof LocalDate) {
            return DataConverterUtils.localDateToDate((LocalDate)value);
        }
        if (value instanceof OffsetTime) {
            return DataConverterUtils.offsetTimeToTime((OffsetTime)value);
        }
        if (value instanceof LocalTime) {
            return DataConverterUtils.localTimeToTime((LocalTime)value);
        }
        if (value instanceof InternalIsoDuration) {
            return DataConverterUtils.durationToMap((InternalIsoDuration)value);
        }
        if (value instanceof Path) {
            return PathSerializer.toPath((Path)value);
        }
        if (value instanceof Node) {
            return DataConverterUtils.nodeToMap((Node)value);
        }
        if (value instanceof Relationship) {
            return DataConverterUtils.relationshipToMap((Relationship)value);
        }
        if (value instanceof Point) {
            return DataConverterUtils.pointToMap((Point)converted);
        }
        return converted;
    }

    public static Map<String, Object> pointToMap(Point point) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("srid", point.srid());
        map.put("x", point.x());
        map.put("y", point.y());
        switch (point.srid()) {
            case 7203: {
                map.put("crs", "cartesian");
                break;
            }
            case 9157: {
                map.put("crs", "cartesian-3d");
                map.put("z", point.z());
                break;
            }
            case 4326: {
                map.put("crs", "wgs-84");
                map.put("longitude", point.x());
                map.put("latitude", point.y());
                break;
            }
            case 4979: {
                map.put("crs", "wgs-84-3d");
                map.put("longitude", point.x());
                map.put("latitude", point.y());
                map.put("height", point.z());
                map.put("z", point.z());
            }
        }
        return map;
    }

    public static List convertList(List list) {
        ArrayList<Object> converted = new ArrayList<Object>(list.size());
        for (Object o : list) {
            converted.add(DataConverterUtils.convertObject(o));
        }
        return converted;
    }

    public static Map<String, Object> durationToMap(InternalIsoDuration obj) {
        HashMap<String, Object> converted = new HashMap<String, Object>(16);
        converted.put("duration", obj.toString());
        converted.put("months", obj.months());
        converted.put("days", obj.days());
        converted.put("seconds", obj.seconds());
        converted.put("nanoseconds", obj.nanoseconds());
        return converted;
    }

    public static Map<String, Object> convertFields(Map<String, Object> fields) {
        HashMap<String, Object> converted = new HashMap<String, Object>();
        Set<Map.Entry<String, Object>> entrySet = fields.entrySet();
        for (Map.Entry<String, Object> entry : entrySet) {
            converted.put(entry.getKey(), DataConverterUtils.convertObject(entry.getValue()));
        }
        return converted;
    }

    public static Map<String, Object> nodeToMap(Node value) {
        LinkedHashMap<String, Object> nodeMap = new LinkedHashMap<String, Object>();
        nodeMap.put("_id", value.id());
        nodeMap.put("_labels", value.labels());
        nodeMap.putAll(DataConverterUtils.convertFields(value.asMap()));
        return nodeMap;
    }

    public static Map<String, Object> relationshipToMap(Relationship value) {
        LinkedHashMap<String, Object> relMap = new LinkedHashMap<String, Object>();
        relMap.put("_id", value.id());
        relMap.put("_type", value.type());
        relMap.put("_startId", value.startNodeId());
        relMap.put("_endId", value.endNodeId());
        relMap.putAll(DataConverterUtils.convertFields(value.asMap()));
        return relMap;
    }
}

