/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.impl;

import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Struct;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import org.neo4j.jdbc.Neo4jArray;
import org.neo4j.jdbc.Neo4jConnection;
import org.neo4j.jdbc.Wrapper;
import org.neo4j.jdbc.impl.ListArray;
import org.neo4j.jdbc.utils.ExceptionBuilder;

public abstract class Neo4jConnectionImpl
implements Neo4jConnection {
    private String url;
    private Properties properties;
    private Properties clientInfo;
    private boolean readOnly = false;
    private int holdability;
    protected static final String FASTEST_STATEMENT = "RETURN 1";

    protected Neo4jConnectionImpl(Properties properties, String url, int defaultHoldability) {
        this.url = url;
        this.properties = properties;
        this.holdability = defaultHoldability;
    }

    public static boolean hasDebug(Properties properties) {
        return "true".equalsIgnoreCase(properties.getProperty("debug", "false"));
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    @Override
    public Properties getProperties() {
        return this.properties;
    }

    @Override
    public String getUserName() {
        return this.properties.getProperty("user");
    }

    @Override
    public int getFlattening() {
        String flatten = this.properties.getProperty("flatten");
        return flatten == null ? 0 : Integer.parseInt(flatten);
    }

    protected void checkClosed() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("Connection already closed");
        }
    }

    protected void checkAutoCommit() throws SQLException {
        if (this.getAutoCommit()) {
            throw new SQLException("Cannot commit when in autocommit");
        }
    }

    protected void checkReadOnly(String query) throws SQLException {
        if (this.isReadOnly() && this.isMutating(query)) {
            throw new SQLException("Mutating Query in readonly mode: " + query);
        }
    }

    private boolean isMutating(String query) {
        return query.matches("(?is).*\\b(create|merge|delete|set)\\b.*");
    }

    protected void checkHoldabilityParams(int resultSetHoldability) throws SQLException {
        if (resultSetHoldability != 1 && resultSetHoldability != 2) {
            throw new SQLFeatureNotSupportedException();
        }
    }

    protected void checkConcurrencyParams(int resultSetConcurrency) throws SQLException {
        if (resultSetConcurrency != 1008 && resultSetConcurrency != 1007) {
            throw new SQLFeatureNotSupportedException();
        }
    }

    protected void checkTypeParams(int resultSetType) throws SQLException {
        if (resultSetType != 1003 && resultSetType != 1004 && resultSetType != 1005) {
            throw new SQLFeatureNotSupportedException();
        }
    }

    protected void checkTransactionIsolation(int level) throws SQLException {
        int[] invalid = new int[]{0, 2, 1, 4, 8};
        if (!Arrays.asList(new int[][]{invalid}).contains(level)) {
            throw new SQLException();
        }
    }

    private void checkAutoGeneratedKeys(int autoGeneratedKeys) throws SQLException {
        if (autoGeneratedKeys != 1 && autoGeneratedKeys != 2) {
            throw new SQLException();
        }
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        this.checkClosed();
        this.doSetReadOnly(readOnly);
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        this.checkClosed();
        return this.readOnly;
    }

    protected void doSetReadOnly(boolean readOnly) throws SQLException {
        this.readOnly = readOnly;
    }

    protected boolean getReadOnly() throws SQLException {
        return this.readOnly;
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        this.checkClosed();
        this.checkHoldabilityParams(holdability);
        this.holdability = holdability;
    }

    @Override
    public int getHoldability() throws SQLException {
        this.checkClosed();
        return this.holdability;
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        this.checkClosed();
    }

    @Override
    public String getCatalog() throws SQLException {
        this.checkClosed();
        return null;
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        this.checkClosed();
        return 2;
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        this.checkClosed();
        this.checkTransactionIsolation(level);
        if (level != 2) {
            throw new SQLException("Unsupported isolation level");
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        this.checkAutoGeneratedKeys(autoGeneratedKeys);
        return this.prepareStatement(sql);
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        return sql;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return Wrapper.unwrap(iface, this);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return Wrapper.isWrapperFor(iface, this.getClass());
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.checkClosed();
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.checkClosed();
    }

    @Override
    public String getSchema() throws SQLException {
        this.checkClosed();
        return null;
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        throw ExceptionBuilder.buildUnsupportedOperationException();
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        throw ExceptionBuilder.buildUnsupportedOperationException();
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        return Collections.emptyMap();
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        throw ExceptionBuilder.buildUnsupportedOperationException();
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        throw ExceptionBuilder.buildUnsupportedOperationException();
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        throw ExceptionBuilder.buildUnsupportedOperationException();
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        throw ExceptionBuilder.buildUnsupportedOperationException();
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        throw ExceptionBuilder.buildUnsupportedOperationException();
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        throw ExceptionBuilder.buildUnsupportedOperationException();
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        throw ExceptionBuilder.buildUnsupportedOperationException();
    }

    @Override
    public Clob createClob() throws SQLException {
        throw ExceptionBuilder.buildUnsupportedOperationException();
    }

    @Override
    public Blob createBlob() throws SQLException {
        throw ExceptionBuilder.buildUnsupportedOperationException();
    }

    @Override
    public NClob createNClob() throws SQLException {
        throw ExceptionBuilder.buildUnsupportedOperationException();
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        throw ExceptionBuilder.buildUnsupportedOperationException();
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        if (name != null && value != null) {
            if (this.clientInfo == null) {
                this.clientInfo = new Properties();
            }
            this.clientInfo.setProperty(name, value);
        }
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        this.clientInfo = properties;
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        return this.clientInfo != null ? this.clientInfo.getProperty(name) : null;
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        return this.clientInfo;
    }

    @Override
    public Neo4jArray createArrayOf(String typeName, Object[] elements) throws SQLException {
        return new ListArray(typeName, elements);
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        throw ExceptionBuilder.buildUnsupportedOperationException();
    }

    @Override
    public void setSchema(String schema) throws SQLException {
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        throw ExceptionBuilder.buildUnsupportedOperationException();
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        throw ExceptionBuilder.buildUnsupportedOperationException();
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        throw ExceptionBuilder.buildUnsupportedOperationException();
    }
}

